/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequest;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class IsAnonymousLogon
extends DefaultHandler {
    private static final String AUTHPROVIDER_COGNOS = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class=\"Cognos\"]";
    private static final String ALLOWANON_VALUE_TEXT = "/*[local-name()='parameter'][@name=\"allowAnon\"]/*[local-name()='value']/text()";
    private static final String DISABLECM_VALUE_TEXT = "/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()";
    private boolean anonymousAllowedFlag;
    private boolean disableCMFlag;

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        boolean retval = true;
        if (!this.isAnonymousAllowed(outboundDirection)) {
            retval = false;
        } else if (this.isCMDisabled(outboundDirection)) {
            retval = false;
        } else if (this.ignoreAnonymousLogon(theContext)) {
            retval = false;
        } else if (this.isTrustedCredential(theContext) && !this.isLogonToCognosNamespace(theContext)) {
            retval = false;
        } else if (this.isSecondaryLogon(theContext)) {
            retval = false;
        }
        return retval;
    }

    private boolean ignoreAnonymousLogon(MessageContext theContext) throws SoapFaultException {
        SoapEnvelope soapReq = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapBodyEntry bodyEntry = soapReq.getBody().getBodyEntry();
        if (bodyEntry.getType() != 2) {
            return false;
        }
        LogonRequest req = (LogonRequest)soapReq.getBody().getBodyEntry();
        boolean retval = false;
        String[] options = req.getOptions();
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!options[i].equals("IgnoreAnonymous")) continue;
                retval = true;
                break;
            }
            boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
            if (retval && outboundDirection) {
                Message msg = new Message("AAA_AUT_ANON_LOGON_DISABLED_REQ");
                throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, IsAnonymousLogon.class.toString(), null, "AAA_AUT_ANON_LOGON_DISABLED_REQ", (LocalizableMessage)msg);
            }
        }
        return retval;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.anonymousAllowedFlag = false;
        this.disableCMFlag = false;
        String value = config.getOptionalValue("./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"allowAnon\"]/*[local-name()='value']/text()", "false");
        this.anonymousAllowedFlag = Boolean.valueOf(value);
        value = config.getOptionalValue("./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()", Boolean.FALSE.toString());
        this.disableCMFlag = Boolean.valueOf(value);
    }

    private boolean isAnonymousAllowed(boolean theOutboundFlag) throws SoapFaultException {
        if (!this.anonymousAllowedFlag && theOutboundFlag) {
            Message msg = new Message("AAA_AUT_ANON_LOGON_DISABLED_CFG");
            throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, IsAnonymousLogon.class.toString(), null, "AAA_AUT_ANON_LOGON_DISABLED_CFG", (LocalizableMessage)msg);
        }
        return this.anonymousAllowedFlag;
    }

    private boolean isCMDisabled(boolean theOutboundFlag) throws SoapFaultException {
        if (this.disableCMFlag && theOutboundFlag) {
            Message msg = new Message("AAA_AUT_ANON_LOGON_DISABLED_CFG");
            throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, IsAnonymousLogon.class.toString(), null, "AAA_AUT_ANON_LOGON_DISABLED_CFG", (LocalizableMessage)msg);
        }
        return this.disableCMFlag;
    }

    private boolean isLogonToCognosNamespace(MessageContext theContext) {
        boolean retval = false;
        Credential[] credentials = (Credential[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        if (credentials == null || credentials.length != 1) {
            return false;
        }
        try {
            String namespaceID = credentials[0].getCredentialValue("namespace");
            if (namespaceID != null && namespaceID.length() == 0) {
                retval = true;
            }
        }
        catch (LocalizableException localizableException) {
            // empty catch block
        }
        return retval;
    }

    private boolean isSecondaryLogon(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection;
        boolean retval = false;
        String passportID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passportID");
        if (passportID == null) {
            return false;
        }
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        if (!PassportManager.getInstance().isAnonymousPassportID(passportID) || passport != null) {
            retval = true;
        }
        if ((outboundDirection = ((Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound")).booleanValue()) && retval) {
            Message msg = new Message("AAA_AUT_ANON_LOGON_OVER_EXISTING");
            throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, IsAnonymousLogon.class.toString(), null, "AAA_AUT_ANON_LOGON_OVER_EXISTING", (LocalizableMessage)msg);
        }
        return retval;
    }

    private boolean isTrustedCredential(MessageContext theContext) throws SoapFaultException {
        Boolean isTC = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted");
        boolean retval = false;
        if (isTC != null && isTC.booleanValue()) {
            boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
            retval = true;
            if (outboundDirection) {
                Message msg = new Message("AAA_AUT_ANON_LOGON_WITH_TC");
                throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, IsAnonymousLogon.class.toString(), null, "AAA_AUT_ANON_LOGON_WITH_TC", (LocalizableMessage)msg);
            }
        }
        return retval;
    }
}

