/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import java.util.HashMap;

public class IsNSConfiguredForRenewTC
extends DefaultHandler
implements ConfigurationListener {
    private static final String IS_NS_CONFIGURED_FOR_RENEW_TC_CONFIGURATION_CHANGED = "IsNSConfiguredForRenewTC.configurationChanged";
    private static final String RENEW_TC_SWITCH_XPATH = "./*[local-name()='parameter' and @name='renewTCFlag']/*[local-name()='value']";
    private static final String OFF_STR = "off";
    private static final int OFF = 0;
    private static final int PRIMARY_ONLY = 1;
    private static final int ALL = 2;
    private static final HashMap<String, Integer> MAP = new HashMap();
    private int renewTCSwitch;
    private TraceLogger traceLogger;

    @Override
    public void configurationChanged(Configuration theNewConfiguration) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, IS_NS_CONFIGURED_FOR_RENEW_TC_CONFIGURATION_CHANGED);
        int oldRenewTCSwitch = this.renewTCSwitch;
        Integer i = MAP.get(theNewConfiguration.getOptionalValue(RENEW_TC_SWITCH_XPATH, OFF_STR));
        this.renewTCSwitch = i != null ? i : 0;
        LogData logData = this.traceLogger.getLogData();
        logData.addParameter("Old renew TC switch value: ", Integer.toString(oldRenewTCSwitch));
        logData.addParameter("New renew TC switch value: ", Integer.toString(this.renewTCSwitch));
        this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "IsNSConfiguredForRenewTC.values", logData);
        this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, IS_NS_CONFIGURED_FOR_RENEW_TC_CONFIGURATION_CHANGED);
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{RENEW_TC_SWITCH_XPATH};
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        boolean ret = false;
        switch (this.renewTCSwitch) {
            case 0: {
                ret = false;
                break;
            }
            case 2: {
                ret = true;
                break;
            }
            case 1: {
                String primaryNsId;
                Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
                if (passport == null || (primaryNsId = passport.getPrimaryNsID()) == null || primaryNsId.equals("")) break;
                String targetNsId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
                ret = primaryNsId.equals(targetNsId);
                break;
            }
        }
        return ret;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        super.init(theConfig);
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        if (config instanceof ConfigurationManager) {
            ((ConfigurationManager)config).addListener(this);
        }
        this.configurationChanged(config);
    }

    static {
        MAP.put(OFF_STR, 0);
        MAP.put("primaryNamespace", 1);
        MAP.put("allNamespaces", 2);
    }
}

