/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.ibm.cognos.camaaa.internal.common.exception.HandlerChainConfigException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class IsTrustedRequest
extends DefaultHandler {
    public static final String AASERVICE = "AAService";
    public static final String CM = "CM";
    private TrustedRequestSession session;
    private final Set trustedServiceIds = new HashSet();

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        SoapEnvelopeRequest envelop = (SoapEnvelopeRequest)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        Element req = null;
        if (envelop instanceof SoapEnvelopeRequestImpl) {
            req = ((SoapEnvelopeRequestImpl)envelop).getElement();
        }
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        boolean trustedRequest = false;
        try {
            if (this.session.isTrusted(req.asXML().getBytes())) {
                String serviceID = this.session.getServiceID(req.asXML().getBytes());
                trustedRequest = this.trustedServiceIds.contains(serviceID);
            }
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(IsTrustedRequest.class.getName(), (Exception)((Object)e));
        }
        if (trustedRequest) {
            return true;
        }
        if (!outboundDirection) {
            return false;
        }
        throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), IsTrustedRequest.class.getName(), null, "AAA_REQ_E_TRUSTED_REQUEST_REQUIRED", (LocalizableMessage)new Message("AAA_REQ_E_TRUSTED_REQUEST_REQUIRED"));
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        String handlerConfiguration = (String)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfiguration");
        SAXReader xmlReader = new SAXReader();
        try {
            StringReader stringReader = new StringReader(handlerConfiguration);
            Document doc = xmlReader.read((Reader)stringReader);
            Element root = doc.getRootElement();
            List serviceIdsList = DocumentHelper.selectNodes((String)"./*[local-name()='configuration']/*[local-name()='trustedServices']/*[local-name()='trustedService']", (Node)root);
            for (int j = 0; j < serviceIdsList.size(); ++j) {
                Element node = (Element)serviceIdsList.get(j);
                String id = node.attributeValue("id");
                if (id == null) continue;
                this.trustedServiceIds.add(id);
            }
            CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
            this.session = camf.createTrustedSession();
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(IsTrustedRequest.class.getName(), (Exception)((Object)e));
        }
        catch (DocumentException e) {
            throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
        }
    }
}

