/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.CAM_AAA.authentication.IAuthenticationListener;
import com.cognos.CAM_AAA.authentication.IBiBusHeader;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.exception.SystemRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.IBiBusHeaderCompatibilityAdapter;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.BadXmlFileException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.AuditLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.XMLSerializer;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.common.util.CustomProviderProxyAdapter;
import com.ibm.cognos.camaaa.internal.common.util.ReadProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class ProcessAuthenticationEvent
extends DefaultHandler {
    public static final String BUILT_IN_NAMESPACE_LISTENERS = ProcessAuthenticationEvent.class.getCanonicalName() + ".Built-in listeners";
    public static final String CLONE_PASSPORT = "ClonePassport";
    public static final String LOGON = "Logon";
    public static final String LOGON_EXPIRED = "LogonExpired";
    public static final String FORCED_LOGOFF = "ForcedLogoff";
    public static final String LOGOFF = "Logoff";
    public static final String SELECT_TENANTS = "SelectTenants";
    public static final String SUCCESS = "Success";
    public static final String FAILURE = "Failure";
    private static final String ORIGINAL_REMOTE_ADDR = "ORIGINAL_REMOTE_ADDR";
    private static final String REMOTE_ADDR = "REMOTE_ADDR";
    private static final String CONFIGURED_NS_PARM = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class!=\"Cognos\"]/*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()";
    private static final String CONFIGURATION_PROPERTIES_FILE = "../configuration/AAA.properties";
    private static final String NAMESPACE = "namespace";
    private static final String NOT_AVAILABLE = "not available";
    private static final String FORM_FIELD = "./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='hdrSession']/*[local-name()='formFieldVars']";
    private static final String FORM_FIELD_CAM_USERNAME = "./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='hdrSession']/*[local-name()='formFieldVars']/*[local-name()='item']/*[local-name()='name'][camaaa:element-text(.)='CAMUsername']";
    private static final XPath FORM_FIELD_CAM_USERNAME_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='hdrSession']/*[local-name()='formFieldVars']/*[local-name()='item']/*[local-name()='name'][camaaa:element-text(.)='CAMUsername']");
    private static final String USERNAME_XPATH_EXP = "./*[local-name()='username']";
    private static final XPath USERNAME_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='username']");
    private static final String VALUE_XPATH_EXP = "./*[local-name()='value']";
    private static final XPath VALUE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='value']");
    private static final String CAM_USERNAME = "./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='username']";
    private static final XPath CAM_USERNAME_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='username']");
    private static final String CAM_CREDENTIAL_USERNAME = "./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='credential']/*[local-name()='username']";
    private static final XPath CAM_CREDENTIAL_USERNAME_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='credential']/*[local-name()='username']");
    private static final String CAM_CREDENTIAL = "./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='credentials']/*[local-name()='credential']";
    private static final XPath CAM_CREDENTIAL_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='credentials']/*[local-name()='credential']");
    private static final Map<String, List<IAuthenticationListener>> LISTENERS = Collections.synchronizedMap(new HashMap());
    private final AuditLoggerImpl logger;
    private ReadProperties aProperties;

    public ProcessAuthenticationEvent() {
        LogTypedLogger typedLogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditIndication.class);
        this.logger = new AuditLoggerImpl(typedLogger);
    }

    @Override
    public void close(MessageContext theContext) {
        String eventType;
        String eventStatus = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventStatus");
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        String logStatus = SUCCESS;
        String errorMessage = null;
        if (eventStatus == null) {
            return;
        }
        if (eventStatus.equals(FAILURE)) {
            logStatus = FAILURE;
            SoapEnvelopeResponse soapEnvelopeResp = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
            SoapFault fault = soapEnvelopeResp.getFaultEntry();
            if (this.isInitialLogonPrompt(fault)) {
                return;
            }
            errorMessage = this.getErrorMessage(fault, requestContext);
        }
        SoapEnvelope soapEnvelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        BiBusHeader biBusHeader = soapEnvelope.getHeader().getBiBusHeader();
        String remoteAddr = null;
        if (biBusHeader != null) {
            try {
                remoteAddr = biBusHeader.getEnvVarValue(ORIGINAL_REMOTE_ADDR);
                if (remoteAddr == null) {
                    remoteAddr = biBusHeader.getEnvVarValue(REMOTE_ADDR);
                }
            }
            catch (LocalizableException e) {
                remoteAddr = null;
            }
        }
        if ((eventType = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType")).equals(CLONE_PASSPORT)) {
            this.generateClonePassportIFPIndications(theContext, requestContext.getLogContext(), logStatus, errorMessage, biBusHeader, remoteAddr, eventType);
        } else {
            this.generateIPFIndication(logStatus, requestContext.getLogContext(), errorMessage, remoteAddr, theContext);
            if (eventStatus.equals(SUCCESS)) {
                this.invokeListener(biBusHeader, theContext);
            }
        }
    }

    private void generateClonePassportIFPIndications(MessageContext theContext, LogContext logContext, String logStatus, String errorMessage, BiBusHeader biBusHeader, String remoteAddr, String eventType) {
        String eventStatus = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventStatus");
        String orginalNS = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        Set<String> namespaces = passport.getAuthenticatedNamespaceIDs();
        for (String ns : namespaces) {
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)LOGON);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)ns);
            this.generateIPFIndication(logStatus, logContext, errorMessage, remoteAddr, theContext);
            if (!eventStatus.equals(SUCCESS)) continue;
            this.invokeListener(biBusHeader, theContext);
        }
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)eventType);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)orginalNS);
    }

    private static boolean logRemoteAddr(String eventType, String remoteAddr) {
        boolean result = false;
        if (remoteAddr != null && !remoteAddr.isEmpty() && (eventType.equals(LOGON) || eventType.equals(LOGOFF) || eventType.equals(FORCED_LOGOFF))) {
            result = true;
        }
        return result;
    }

    private void generateIPFIndication(String logStatus, LogContext logContext, String errorMessage, String remoteAddr, MessageContext theContext) {
        Component component = ComponentImpl.getInstance();
        if (this.logger.isEnabled(40000)) {
            String eventType = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType");
            String theNamespace = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
            Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            InternalVisa internalVisa = null;
            if (passport != null) {
                internalVisa = passport.getInternalVisa(theNamespace);
            }
            LogData logData = this.getLogData(theContext);
            String username = this.prepareLogData(theContext, theNamespace, internalVisa, logData);
            if (eventType == null) {
                return;
            }
            if (ProcessAuthenticationEvent.logRemoteAddr(eventType, remoteAddr)) {
                logData.addParameter(REMOTE_ADDR, remoteAddr);
            }
            if (eventType.equals(LOGON)) {
                this.addTenantID(passport, logData);
                this.logger.logAuthenticationEvent(logContext, component, 40000, logData, theNamespace, username, LOGON, logStatus, errorMessage);
            } else if (eventType.equals(LOGON_EXPIRED)) {
                this.logger.logAuthenticationEvent(logContext, component, 40000, logData, theNamespace, username, LOGON_EXPIRED, logStatus, errorMessage);
            } else if (eventType.equals(LOGOFF)) {
                this.logger.logAuthenticationEvent(logContext, component, 40000, logData, theNamespace, username, LOGOFF, logStatus, errorMessage);
            } else if (eventType.equals(FORCED_LOGOFF)) {
                this.logger.logAuthenticationEvent(logContext, component, 40000, logData, theNamespace, username, FORCED_LOGOFF, logStatus, errorMessage);
            } else if (eventType.equals(SELECT_TENANTS)) {
                this.addWriteTenantID(passport, logData);
                this.logger.logAuthenticationEvent(logContext, component, 40000, logData, theNamespace, username, SELECT_TENANTS, logStatus, errorMessage);
            }
        }
    }

    private String prepareLogData(MessageContext theContext, String theNamespace, InternalVisa internalVisa, LogData logData) {
        String username;
        logData.addParameter(NAMESPACE, theNamespace);
        String displayName = NOT_AVAILABLE;
        String searchPath = NOT_AVAILABLE;
        if (internalVisa != null) {
            username = internalVisa.getUsername();
            displayName = internalVisa.getDisplayName();
            searchPath = internalVisa.getCAMID();
        } else {
            SoapEnvelope soapEnvelopeReq = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
            username = this.getUsername(soapEnvelopeReq);
        }
        if (username == null) {
            username = NOT_AVAILABLE;
        }
        logData.addParameter("username", username);
        logData.addParameter("display name", displayName);
        logData.addParameter("CAMID", searchPath);
        return username;
    }

    private void addTenantID(Passport passport, LogData logData) {
        String tenantId = this.getTenantID(passport, TenancyInfo.TenancyType.TENANTID);
        logData.addParameter(TenancyInfo.TenancyType.TENANTID.toString(), tenantId);
    }

    private void addWriteTenantID(Passport passport, LogData logData) {
        String tenantId = this.getTenantID(passport, TenancyInfo.TenancyType.WRITE_TENANTID, null);
        if (tenantId == null) {
            tenantId = this.getTenantID(passport, TenancyInfo.TenancyType.TENANTID);
        }
        logData.addParameter(TenancyInfo.TenancyType.TENANTID.toString(), tenantId);
    }

    private String getTenantID(Passport passport, TenancyInfo.TenancyType tenancyType) {
        return this.getTenantID(passport, tenancyType, "");
    }

    private String getTenantID(Passport passport, TenancyInfo.TenancyType tenancyType, String defaultValue) {
        String tenantId = defaultValue;
        if (passport != null) {
            String tenantIDFromPassport;
            try {
                tenantIDFromPassport = passport.getTenancyInfo().getTenancy(tenancyType);
            }
            catch (SoapFaultException e) {
                tenantIDFromPassport = e.getLocalizedMessage();
            }
            if (tenantIDFromPassport != null) {
                tenantId = tenantIDFromPassport;
            }
        }
        return tenantId;
    }

    private LogData getLogData(MessageContext theContext) {
        LogData logData = (LogData)theContext.remove((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logData");
        if (logData == null) {
            return this.logger.getLogData();
        }
        return logData;
    }

    private String getErrorMessage(SoapFault theFault, RequestContext theRequestContext) {
        LocalizableMessage[] reasonForFailure = theFault.getFaultDetail();
        if (reasonForFailure != null) {
            Element element = XMLSerializer.generateMessagesElement(theFault, theRequestContext);
            return LogDataImpl.toCompactNoDeclarationUtf8String(element);
        }
        return null;
    }

    private IAuthenticationListener getListener(String theClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> listenerClass = Class.forName(theClassName, true, CustomProviderProxyAdapter.getProviderClassLoader());
        return (IAuthenticationListener)listenerClass.newInstance();
    }

    private String getListenerKey(String theNamespaceID, int theIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("authentication.listener.");
        if (theNamespaceID != null) {
            buffer.append("namespace.");
            buffer.append(theNamespaceID);
            buffer.append('.');
        }
        buffer.append(theIndex);
        return buffer.toString();
    }

    private Properties getListenerProperties(File theFilename) throws BadXmlFileException {
        Properties properties = new Properties();
        if (theFilename.exists()) {
            try {
                properties.load(new FileInputStream(theFilename));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                throw new BadXmlFileException(theFilename.getAbsolutePath(), e);
            }
        }
        return properties;
    }

    private String getUsername(SoapEnvelope request) {
        List camCredentials;
        Element camUsernameElement;
        String username = null;
        SoapEnvRequestImpl requestImpl = null;
        if (request instanceof SoapEnvRequestImpl) {
            requestImpl = (SoapEnvRequestImpl)request;
        }
        if (requestImpl == null) {
            return username;
        }
        Element soapEnvelope = requestImpl.getElement();
        Element formFieldItemNameElement = DocumentHelper.selectSingleElement((XPath)FORM_FIELD_CAM_USERNAME_XPATH, (Node)soapEnvelope);
        if (formFieldItemNameElement != null) {
            Element itemElement = formFieldItemNameElement.getParent();
            Element usernameValueElement = DocumentHelper.selectSingleElement((XPath)VALUE_XPATH, (Node)itemElement);
            username = usernameValueElement.getText();
        }
        if ((camUsernameElement = DocumentHelper.selectSingleElement((XPath)CAM_USERNAME_XPATH, (Node)soapEnvelope)) != null) {
            username = camUsernameElement.getText();
        }
        if ((camUsernameElement = DocumentHelper.selectSingleElement((XPath)CAM_CREDENTIAL_USERNAME_XPATH, (Node)soapEnvelope)) != null) {
            username = camUsernameElement.getText();
        }
        if ((camCredentials = DocumentHelper.selectElements((XPath)CAM_CREDENTIAL_XPATH, (Node)soapEnvelope)) != null) {
            for (int i = 0; i < camCredentials.size(); ++i) {
                Element camCredentialElement = (Element)camCredentials.get(i);
                Element usernameElement = DocumentHelper.selectSingleElement((XPath)USERNAME_XPATH, (Node)camCredentialElement);
                if (usernameElement == null) continue;
                username = usernameElement.getText();
            }
        }
        return username;
    }

    @Override
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventStatus", (Object)FAILURE);
        return true;
    }

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventStatus", (Object)FAILURE);
        } else {
            this.setEventType(theContext);
            if (theContext.containsKey((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType")) {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventStatus", (Object)SUCCESS);
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logData", (Object)this.logger.getLogData());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        IAuthenticationListener[] builtinListeners = (IAuthenticationListener[])theConfig.get((Object)BUILT_IN_NAMESPACE_LISTENERS);
        Configuration configuration = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        Properties properties = this.getListenerProperties(new File(configuration.getAbsolutePath(CONFIGURATION_PROPERTIES_FILE)));
        String[] securityNsName = configuration.getOptionalValues(CONFIGURED_NS_PARM, null);
        this.aProperties = new ReadProperties(properties);
        Map<String, List<IAuthenticationListener>> map = LISTENERS;
        synchronized (map) {
            if (LISTENERS.size() == 0) {
                if (securityNsName != null) {
                    for (int i = 0; i < securityNsName.length; ++i) {
                        this.populateListeners(properties, securityNsName[i]);
                    }
                }
                this.populateListeners(properties, null);
            }
            if (builtinListeners != null && builtinListeners.length > 0) {
                List<IAuthenticationListener> globalListeners = LISTENERS.get(null);
                for (IAuthenticationListener listener : builtinListeners) {
                    if (globalListeners.contains(listener)) continue;
                    globalListeners.add(listener);
                }
            }
        }
    }

    private void invokeListener(BiBusHeader biBusHeader, MessageContext messageContext) {
        List<IAuthenticationListener> namespaceListeners;
        String eventType = (String)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType");
        String targetNS = (String)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        Passport passport = (Passport)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        List<IAuthenticationListener> globalListeners = LISTENERS.get(null);
        if (globalListeners != null) {
            this.invokeListeners(globalListeners, eventType, passport, biBusHeader, targetNS, messageContext);
        }
        if ((namespaceListeners = LISTENERS.get(targetNS)) != null) {
            this.invokeListeners(namespaceListeners, eventType, passport, biBusHeader, targetNS, messageContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListeners(List<IAuthenticationListener> theListeners, String eventType, Passport passport, BiBusHeader biBusHeader, String targetNS, MessageContext messageContext) {
        String userID = null;
        String passportID = null;
        if (passport != null) {
            passportID = passport.getID();
            InternalVisa visa = passport.getInternalVisa(targetNS);
            if (visa != null) {
                userID = visa.getUsername();
            }
        }
        IBiBusHeaderCompatibilityAdapter oldBiBusHeader = new IBiBusHeaderCompatibilityAdapter(biBusHeader, messageContext);
        Iterator<IAuthenticationListener> it = theListeners.iterator();
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            while (it.hasNext()) {
                IAuthenticationListener listener = it.next();
                if (eventType.equals(LOGON)) {
                    listener.logon(passportID, targetNS, userID, (IBiBusHeader)oldBiBusHeader);
                    continue;
                }
                if (eventType.equals(LOGOFF)) {
                    listener.logoff(passportID, targetNS, userID, (IBiBusHeader)oldBiBusHeader);
                    continue;
                }
                if (eventType.equals(LOGON_EXPIRED)) {
                    listener.logonExpired(passportID, targetNS, userID, (IBiBusHeader)oldBiBusHeader);
                    continue;
                }
                if (!eventType.equals(FORCED_LOGOFF)) continue;
                listener.forcedLogoff(passportID, targetNS, userID, (IBiBusHeader)oldBiBusHeader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    private boolean isInitialLogonPrompt(SoapFault theFault) {
        if (theFault == null) {
            return true;
        }
        LocalizableMessage[] reasonForFailure = theFault.getFaultDetail();
        return theFault instanceof SystemRecoverableException || (reasonForFailure == null || reasonForFailure.length == 0) && theFault instanceof UserRecoverableException;
    }

    private void populateListeners(Properties theProperties, String theNamespaceID) {
        String propertyName;
        ArrayList<IAuthenticationListener> list = new ArrayList<IAuthenticationListener>();
        LISTENERS.put(theNamespaceID, list);
        int i = 1;
        while (theProperties.containsKey(propertyName = this.getListenerKey(theNamespaceID, i))) {
            try {
                IAuthenticationListener listener = this.getListener(theProperties.getProperty(propertyName));
                list.add(listener);
                StringBuffer aMessage = new StringBuffer();
                aMessage.append("*** Added generic listener class: ");
                aMessage.append(listener.toString());
                if (theNamespaceID != null) {
                    aMessage.append(" for namespace " + theNamespaceID);
                }
                this.aProperties.logTraceLogic(aMessage.toString());
            }
            catch (Throwable t) {
                this.aProperties.logTraceException(t);
                t.printStackTrace();
            }
            ++i;
        }
        if (this.aProperties.traceLogicEnabled()) {
            Package customAPI = Package.getPackage("com.cognos.CAM_AAA.authentication");
            try {
                if (customAPI == null || customAPI.getSpecificationVersion() != null && !customAPI.isCompatibleWith("1.1")) {
                    throw new IncompatibleClassChangeError("This implementation is not compatible with this version of package " + customAPI.getSpecificationTitle() + "version " + customAPI.getImplementationVersion());
                }
                this.aProperties.logTraceLogic("Package in use: " + customAPI.toString());
            }
            catch (NumberFormatException e) {
                this.aProperties.logTraceException((Throwable)e);
            }
        }
    }

    private void setEventType(MessageContext theContext) {
        MessageContextImpl.PassportExpireEvent passportExpiredEvent = (MessageContextImpl.PassportExpireEvent)((Object)theContext.get((Object)MessageContextImpl.PASSPORT_EXPIRED_EVENT));
        if (passportExpiredEvent != null) {
            switch (passportExpiredEvent) {
                case LOGONEXPIRED: {
                    theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)LOGON_EXPIRED);
                    break;
                }
                case FORCEDLOGOFF: {
                    theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)FORCED_LOGOFF);
                    break;
                }
            }
        } else {
            SoapEnvelope envelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
            SoapBodyEntry bodyEntry = envelope.getBody().getBodyEntry();
            switch (bodyEntry.getType()) {
                case 2: 
                case 22: {
                    theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)LOGON);
                    break;
                }
                case 20: {
                    theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)CLONE_PASSPORT);
                    break;
                }
                case 4: {
                    theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)LOGOFF);
                    break;
                }
                case 28: {
                    theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.eventType", (Object)SELECT_TENANTS);
                    break;
                }
            }
        }
    }

    static void resetListeners() {
        LISTENERS.clear();
    }
}

