/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequest;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ProcessLogonWithCredentials
extends DefaultHandler {
    static final String CREATED_SESSION = ProcessLogonWithCredentials.class.getName() + "_CREATED_SESSION";

    private boolean callLogon(MessageContext messageContext) throws SoapFaultException {
        HandlerBinding handlerBinding = (HandlerBinding)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler handler = handlerBinding.getHandler(2);
        handlerBinding.handleRequest(messageContext, handler);
        SoapEnvelope envelope = (SoapEnvelope)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        SoapBodyEntry bodyEntry = envelope.getBody().getBodyEntry();
        if (bodyEntry.getType() == 19) {
            throw new InternalErrorException(ProcessLogonWithCredentials.class.getName());
        }
        return true;
    }

    private void destroySessionIfNeeded(MessageContext context) throws SoapFaultException {
        Boolean createdSession = (Boolean)context.get((Object)CREATED_SESSION);
        if (createdSession != null && createdSession.equals(Boolean.TRUE)) {
            this.logoffAllNamespaces(context);
        }
    }

    @Override
    public boolean handleFault(MessageContext context) throws SoapFaultException {
        this.destroySessionIfNeeded(context);
        return true;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext context) throws SoapFaultException {
        Passport passport;
        String[] options = null;
        Credential[] credentials = null;
        credentials = (Credential[])context.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        if (credentials == null) {
            SoapEnvelopeRequest envelope = (SoapEnvelopeRequest)context.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
            LogonRequest request = (LogonRequest)envelope.getBody().getBodyEntry();
            credentials = request.getCredentials();
            options = request.getOptions();
        }
        if ((passport = (Passport)context.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport")) == null) {
            context.put((Object)CREATED_SESSION, (Object)Boolean.TRUE);
        }
        SoapEnvelopeResponse response = (SoapEnvelopeResponse)context.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        boolean logonSucceeded = true;
        for (int i = 0; i < credentials.length; ++i) {
            Credential[] singleCredential = new Credential[]{credentials[i]};
            MessageContext newContext = this.makeLogonRequestContext(context, options);
            newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse", (Object)response);
            newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)singleCredential);
            if (context.containsKey((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted")) {
                newContext.put((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted", context.get((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted"));
            }
            if (passport != null) {
                newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)passport);
            }
            logonSucceeded = this.callLogon(newContext);
            Passport newPassport = (Passport)newContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            if (passport != newPassport) {
                context.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)newPassport);
                passport = newPassport;
            }
            String cookieValue = (String)newContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.camPassportCookie");
            context.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.camPassportCookie", (Object)cookieValue);
        }
        return logonSucceeded;
    }

    @Override
    protected boolean handleOutboundRequest(MessageContext theContext) throws SoapFaultException {
        this.destroySessionIfNeeded(theContext);
        return true;
    }

    private void logoffAllNamespaces(MessageContext context) throws SoapFaultException {
        Passport passport = (Passport)context.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        HandlerBinding binding = (HandlerBinding)context.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Document document = null;
        try {
            String strReq = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"  xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><SOAP-ENV:Header><bus:biBusHeader><CAM><CAMPassport/></CAM></bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body><bus:logoff/></SOAP-ENV:Body></SOAP-ENV:Envelope>";
            document = DocumentHelper.parseText((String)"<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"  xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><SOAP-ENV:Header><bus:biBusHeader><CAM><CAMPassport/></CAM></bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body><bus:logoff/></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        }
        catch (DocumentException e) {
            throw new FunctionCallFailedException(ProcessLogonWithCredentials.class.toString(), "DocumentHelper.parseText(xmlResponse)", (Exception)((Object)e));
        }
        Element passportIDElement = (Element)DocumentHelper.selectSingleNode((String)"//CAMPassport", (Node)document.getRootElement());
        passportIDElement.setText(passport.getID());
        MessageContextImpl newContext = new MessageContextImpl(document.getRootElement());
        newContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding", binding);
        HandlerBinding handlerBinding = (HandlerBinding)newContext.get("com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler handler = handlerBinding.getHandler(4);
        handlerBinding.handleRequest((MessageContext)newContext, handler);
    }

    private MessageContext makeLogonRequestContext(MessageContext context, String[] options) throws SoapFaultException {
        StringBuffer optionBuffer = new StringBuffer();
        if (options != null) {
            optionBuffer.append("<bus:logonOptions>");
            for (int i = 0; i < options.length; ++i) {
                optionBuffer.append("<bus:item>");
                optionBuffer.append(options[i]);
                optionBuffer.append("</bus:item>");
            }
            optionBuffer.append("</bus:logonOptions>");
        }
        String logonRequest = "<SOAP-ENV:Body xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><bus:logon>" + optionBuffer.toString() + "</bus:logon></SOAP-ENV:Body>";
        MessageContext newContext = context.createMessageContextForNewRequest(logonRequest);
        return newContext;
    }
}

