/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.EnvironmentSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlobManager;
import com.ibm.cognos.camaaa.internal.auth.TrustedToken;
import com.ibm.cognos.camaaa.internal.auth.TrustedTokenManager;
import com.ibm.cognos.camaaa.internal.auth.handler.SingleSignonFaultHandler;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import java.io.UnsupportedEncodingException;

public class ProcessSingleSignon
extends DefaultHandler {
    private static final String CLASS_NAME = ProcessSingleSignon.class.toString();
    private static final String SECURITY_BLOB_FORMFIELD_NAME = "CAM_SecurityBlob";
    private static final String ENCODING = "UTF-8";
    private static final String INVALID_SB_DATA = "Type=-1 , ";
    private final SingleSignonFaultHandler faultHandler = new SingleSignonFaultHandler();
    private SigningSession session;

    private void addSbToBiBusHeader(String securityBlob, BiBusHeader biBusHeader) throws InternalErrorException {
        String encodedSecurityBlob;
        try {
            encodedSecurityBlob = base64.encode((int)0, (byte[])securityBlob.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(CLASS_NAME, e);
        }
        biBusHeader.setCAMSecurityBlob(encodedSecurityBlob);
    }

    @Override
    public void destroy() {
        this.faultHandler.destroy();
    }

    @Override
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        return this.faultHandler.handleFault(theContext);
    }

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        SoapEnvelope soapRequest = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        BiBusHeader biBusHeader = soapRequest.getHeader().getBiBusHeader();
        boolean isSingleSignon = false;
        String securityBlob = biBusHeader.getCAMSecurityBlob();
        if (securityBlob != null) {
            isSingleSignon = true;
            this.processSingleSignon(securityBlob, biBusHeader);
        } else {
            String value;
            try {
                value = biBusHeader.getFormFieldValue(SECURITY_BLOB_FORMFIELD_NAME);
            }
            catch (LocalizableException e) {
                throw new InternalErrorException(CLASS_NAME, (Exception)((Object)e));
            }
            if (value != null) {
                isSingleSignon = true;
                this.processSingleSignon(value, biBusHeader);
            }
        }
        if (isSingleSignon) {
            return true;
        }
        if (!outboundDirection) {
            return false;
        }
        throw new RuntimeException("ProcessSingleSignon Outbound: The request is not a single signon. Check if handler configuration is correct.");
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.faultHandler.init(theConfig);
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createSigningSession();
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(CLASS_NAME, "CAMFactory.createSigningSession", (Exception)((Object)e));
        }
    }

    private void processSingleSignon(String encodedSecurityBlob, BiBusHeader biBusHeader) throws SoapFaultException {
        SecurityBlob securityBlob = SecurityBlobManager.createSecurityBlob(encodedSecurityBlob);
        if (securityBlob != null && securityBlob.getBlobType() == 1) {
            EnvironmentSecurityBlob environmentSecurityBlob = (EnvironmentSecurityBlob)securityBlob;
            boolean sbIsValid = false;
            sbIsValid = this.validateEnvironmentSecurityBlob(environmentSecurityBlob);
            if (sbIsValid) {
                this.addSbToBiBusHeader(environmentSecurityBlob.getEnvironmentRawData(), biBusHeader);
            } else {
                this.addSbToBiBusHeader(INVALID_SB_DATA, biBusHeader);
            }
        } else if (securityBlob == null) {
            biBusHeader.setCAMCheckGateway();
        }
    }

    private boolean validateEnvironmentSecurityBlob(EnvironmentSecurityBlob envSecurityBlob) throws SoapFaultException {
        boolean hashesMatch = false;
        try {
            String envRawData = envSecurityBlob.getEnvironmentRawData();
            byte[] hmacDigest = envSecurityBlob.getHmacDigest();
            if (envRawData != null && hmacDigest != null) {
                hashesMatch = this.session.hmacVerify(hmacDigest, envRawData.getBytes(ENCODING));
            }
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(CLASS_NAME, (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(CLASS_NAME, e);
        }
        if (!hashesMatch) {
            return false;
        }
        return this.validateTrustedToken(envSecurityBlob.getTokenId());
    }

    private boolean validateTrustedToken(String tokenId) {
        TrustedTokenManager trustedTokenManager;
        TrustedToken trustedToken;
        if (tokenId != null && (trustedToken = (trustedTokenManager = TrustedTokenManager.getInstance()).getTrustedToken(tokenId)) != null) {
            trustedTokenManager.destroyTrustedToken(tokenId);
            return true;
        }
        return false;
    }
}

