/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.auth.exception.NamespaceSelectionException;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class PromptForNamespaceSelection
extends DefaultHandler {
    private static final String ACTOR = PromptForNamespaceSelection.class.getName();
    private NamespaceManager namespaceManager;

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.namespaceManager = (NamespaceManager)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.NamespaceManager");
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        final RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        Set availableNS = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.availableNamespaces");
        if (availableNS.isEmpty()) {
            throw new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_COULD_NOT_AUTHENTICATE_USER"), (LocalizableMessage)new Message("AAA_AUT_NO_NAMESPACE_AVAILABLE"));
        }
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (String id : availableNS) {
            namespaces.add(this.namespaceManager.getNamespace(id));
        }
        Comparator<Namespace> compareNamespaceByDefaultName = new Comparator<Namespace>(){

            @Override
            public int compare(Namespace ns1, Namespace ns2) {
                return ns1.getDefaultName(requestContext).compareTo(ns2.getDefaultName(requestContext));
            }
        };
        Collections.sort(namespaces, compareNamespaceByDefaultName);
        NamespaceSelectionException nse = new NamespaceSelectionException(ACTOR, namespaces, requestContext);
        throw nse;
    }
}

