/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.HiddenDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.RetrieveCredentialResponse;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyBiBusHeader;
import java.io.UnsupportedEncodingException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RetrieveNamespaceCredential
extends DefaultHandler {
    private static final String CAM_CREDENTIAL_FLAG = "CAMCredential";
    private EncryptingSession session;

    private void addEncryptedCredentialToResponse(SoapEnvelope response, Credential[] credentials) throws InternalErrorException {
        if (credentials != null && credentials.length == 1 && credentials[0] != null) {
            byte[] encryptedCredentialBytes;
            Element credElement = DocumentHelper.createElement((String)"credential");
            String[] names = credentials[0].getCredentialNames();
            this.addNames(credentials, 0, credElement, names);
            try {
                encryptedCredentialBytes = this.session.encryptData(credElement.asXML().getBytes("UTF-8"));
            }
            catch (CAMCryptoException e) {
                throw new InternalErrorException(RetrieveNamespaceCredential.class.toString(), (Exception)((Object)e));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalErrorException(RetrieveNamespaceCredential.class.toString(), e);
            }
            String encryptedCredential = base64.encode((int)0, (byte[])encryptedCredentialBytes);
            BiBusHeader bibusHeader = response.getHeader().getBiBusHeader();
            if (bibusHeader instanceof LegacyBiBusHeader) {
                LegacyBiBusHeader legacyBibusHeader = (LegacyBiBusHeader)bibusHeader;
                legacyBibusHeader.setCredential(this.getEncryptedValueWrapper(encryptedCredential));
            } else {
                this.setCredentials(response, encryptedCredential);
            }
        }
    }

    private void setCredentials(SoapEnvelope response, String encryptedCredential) {
        if (response.getBody().getBodyEntry().getType() == 15) {
            ((RetrieveCredentialResponse)response.getBody().getBodyEntry()).setCredential(this.getEncryptedValueWrapper(encryptedCredential));
        }
    }

    private void addNames(Credential[] credentails, int i, Element credElement, String[] names) {
        if (names != null) {
            for (int j = 0; j < names.length; ++j) {
                if (names[j] == null || names[j].equals("")) continue;
                String[] values = credentails[i].getCredentialValues(names[j]);
                this.addValues(credElement, names, j, values);
            }
        }
    }

    private void addValues(Element credElement, String[] names, int j, String[] values) {
        if (values != null) {
            for (int k = 0; k < values.length; ++k) {
                if (values[k] == null) continue;
                Element nameElement = DocumentHelper.createElement((String)names[j]);
                nameElement.setText(values[k]);
                credElement.add(nameElement);
            }
        }
    }

    private String getEncryptedValueWrapper(String theValue) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<credential><encryptedValue>");
        buffer.append(theValue);
        buffer.append("</encryptedValue></credential>");
        return buffer.toString();
    }

    @Override
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        SoapEnvelopeResponse response = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        SoapFault soapFault = response.getFaultEntry();
        if (soapFault instanceof UserRecoverableException) {
            UserRecoverableException e = (UserRecoverableException)soapFault;
            HiddenDisplayObject hiddenDisplayObject = new HiddenDisplayObject(CAM_CREDENTIAL_FLAG, String.valueOf(false));
            e.addDisplayObject((DisplayObject)hiddenDisplayObject);
            response.setFaultEntry((SoapFault)e, theContext);
        }
        return true;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        SoapEnvelope response = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        HandlerBinding handlerBinding = (HandlerBinding)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler handler = handlerBinding.getHandler("dispatchToNamespace");
        handlerBinding.handleRequestRequired(theContext, handler);
        Credential[] credentails = (Credential[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        this.addEncryptedCredentialToResponse(response, credentails);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(RetrieveNamespaceCredential.class.toString(), "CAMFactory.createEncryptingSession", (Exception)((Object)e));
        }
    }
}

