/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.RenewTCResponse;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class RetrieveTCs
extends DefaultHandler {
    private static String camIDStartTag = "CAMID(\"";
    private static String camIDEndTag = "\")";
    private EncryptingSession session;
    private ICMAccessor cm;

    private static Document parseText(String value) throws SoapFaultException {
        try {
            return DocumentHelper.parseText((String)value);
        }
        catch (DocumentException e) {
            throw new InternalErrorException(RetrieveTCs.class.toString(), (Exception)((Object)e));
        }
    }

    private String decryptValue(String encryptedValue) throws InternalErrorException {
        String decryptedValue;
        byte[] decodedValue = base64.decode((int)0, (String)encryptedValue);
        try {
            decryptedValue = new String(this.session.decryptData(decodedValue), "UTF8");
        }
        catch (Exception e) {
            throw new InternalErrorException(this.getClass().toString(), e);
        }
        return decryptedValue;
    }

    private String getCredentialPath(MessageContext theContext) {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        String primaryNsId = passport.getPrimaryNsID();
        InternalVisa primaryVisa = passport.getInternalVisa(primaryNsId);
        String camId = primaryVisa.getCAMID();
        int beginIndex = -1;
        int endIndex = -1;
        beginIndex = camId.indexOf(camIDStartTag);
        if (beginIndex != -1) {
            endIndex = camId.lastIndexOf(camIDEndTag);
        }
        String realCamId = beginIndex != -1 && endIndex != -1 ? camId.substring(beginIndex + camIDStartTag.length(), endIndex) : camId;
        String credentialPath = "/directory/namespace[@id='" + primaryNsId + "']//account[@id='" + realCamId + "']/credential";
        return credentialPath;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        String credentialPath = this.getCredentialPath(theContext);
        this.setCredentialPath(theContext, credentialPath);
        String targetNsId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        Element cmResponse = this.queryCMforTCs(theContext, credentialPath);
        String value = DocumentHelper.valueOf((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse/*/*/*/*/*[local-name()='credentials']/*[local-name()='value']", (Node)cmResponse);
        if (value != null) {
            Document doc = RetrieveTCs.parseText(value);
            String encryptedValue = DocumentHelper.valueOf((String)"/*[local-name()='credential']/*[local-name()='encryptedValue']", (Node)doc.getRootElement());
            String decryptedValue = this.decryptValue(encryptedValue);
            List credentialsList = (doc = RetrieveTCs.parseText(decryptedValue)).getRootElement().selectNodes("//credential");
            if (credentialsList != null) {
                try {
                    return this.populateTC(theContext, targetNsId, credentialsList);
                }
                catch (LocalizableException e) {
                    throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
                }
            }
        }
        return false;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.cm = CMAccessor.getInstance();
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
    }

    private boolean populateTC(MessageContext theContext, String targetNsId, List<?> credentialsList) throws LocalizableException {
        Credential[] credentials = new Credential[credentialsList.size()];
        int i = 0;
        boolean ret = false;
        Iterator<?> iterator = credentialsList.iterator();
        while (iterator.hasNext()) {
            CredentialImpl tc = new CredentialImpl((Element)iterator.next());
            if (targetNsId.equals(tc.getCredentialValue("namespace"))) {
                ret = true;
            }
            credentials[i++] = tc;
        }
        if (ret) {
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)credentials);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted", (Object)Boolean.TRUE);
        }
        return ret;
    }

    private Element queryCMforTCs(MessageContext theContext, String credentialPath) throws SoapFaultException {
        Element cmRequestEnvelope;
        SoapEnvelopeResponse soapEnvResponse = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        Element cmRequestBodyElement = CMAccessor.createRequestBodyForTC(new String[]{credentialPath});
        try {
            cmRequestEnvelope = CMAccessor.createCMRequest(cmRequestBodyElement, (SoapEnvelope)soapEnvResponse);
            DocumentHelper.removeMatchedNodes((Element)cmRequestEnvelope, (String[])new String[]{"//CAMPassport"});
        }
        catch (DocumentException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        String request = cmRequestEnvelope.asXML();
        String cmResponseString = this.cm.invoke(request);
        Document doc = RetrieveTCs.parseText(cmResponseString);
        return doc.getRootElement();
    }

    private void setCredentialPath(MessageContext theContext, String credentialPath) {
        SoapEnvelopeResponse env = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        RenewTCResponse response = (RenewTCResponse)env.getBody().getBodyEntry();
        response.setCredentialPath(credentialPath);
    }
}

