/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.UnsupportedEncodingException;

public class RetrieveValidPassport
extends DefaultHandler {
    private static final String ADVANCED_PROPERTIES_XPATH_EXPRESSION = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']";
    private static final String TIED_REMOTE_USER_XPATH_EXPRESSION = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"TieRemoteUserToCAMPassport\"]/*[local-name()='value']/text()";
    private static final String ENCODING = "UTF8";
    private CAMFactory camf;
    private Boolean tieRemoteUserWithPassport = Boolean.FALSE;

    private boolean addOrRemovePassportToMessageContext(MessageContext theContext, Passport passport, String passportID) {
        boolean retval = false;
        try {
            passport.lock();
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        boolean remoteUserMatch = false;
        try {
            remoteUserMatch = this.doesRemoteUserMatch(theContext, passportID, passport);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (CAMCryptoException e) {
            throw new RuntimeException(e);
        }
        catch (LocalizableException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!remoteUserMatch) {
                passport.unlock();
            } else {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)passport);
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public void close(MessageContext theContext) {
    }

    private SecureStateSession createSecureSateSession(String oldPassport, String oldSecureState) throws CAMCryptoException, UnsupportedEncodingException {
        if (oldPassport != null && oldSecureState != null) {
            SecureStateSession oldSession = this.camf.createSecureStateSession(oldPassport.getBytes(ENCODING), oldSecureState.getBytes(ENCODING));
            return oldSession;
        }
        return null;
    }

    private boolean doesRemoteUserMatch(MessageContext theContext, String oldPassportID, Passport passport) throws CAMCryptoException, UnsupportedEncodingException, LocalizableException {
        if (!this.tieRemoteUserWithPassport.booleanValue()) {
            return true;
        }
        boolean verify = false;
        SoapEnvelope requestEnv = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        BiBusHeader requestHdr = requestEnv.getHeader().getBiBusHeader();
        String oldSecureState = null;
        if (requestHdr != null) {
            oldSecureState = requestHdr.getSecureState();
        }
        if (oldPassportID != null && oldSecureState != null) {
            SecureStateSession cafSecureStateSession = this.createSecureSateSession(oldPassportID, oldSecureState);
            if (cafSecureStateSession != null && cafSecureStateSession.verifySecureStateToken()) {
                verify = this.verifyRemoteUserMatch(requestHdr, passport, cafSecureStateSession);
            }
        } else {
            verify = true;
        }
        return verify;
    }

    @Override
    public boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        Passport passport;
        boolean retval = false;
        Passport mcPassport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        String passportID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passportID");
        if (mcPassport != null && mcPassport.getID().equals(passportID)) {
            return true;
        }
        Passport passportIDPassport = PassportManager.getInstance().getPassport(passportID);
        if (passportIDPassport != null) {
            retval = this.addOrRemovePassportToMessageContext(theContext, passportIDPassport, passportID);
        } else if (mcPassport != null && (passport = PassportManager.getInstance().getPassport(mcPassport.getID())) != null) {
            retval = true;
        }
        return retval;
    }

    @Override
    protected boolean handleOutboundRequest(MessageContext theContext) throws SoapFaultException {
        if (theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport") == null) {
            throw new UnrecoverableException(this.getClass().getName(), (LocalizableMessage)new Message("AAA_CAP_SESSION_EXPIRED"), (LocalizableMessage)new Message("AAA_AUT_AUTHENTICATION_REQUIRED"));
        }
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String tieRemoteUserValue = config.getOptionalValue(TIED_REMOTE_USER_XPATH_EXPRESSION, Boolean.FALSE.toString());
        this.tieRemoteUserWithPassport = Boolean.valueOf(tieRemoteUserValue);
        this.camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
    }

    private boolean verifyRemoteUserMatch(BiBusHeader requestHdr, Passport passport, SecureStateSession cafSecureStateSession) throws CAMCryptoException, LocalizableException {
        boolean verify = true;
        if (cafSecureStateSession.getRequestExternal() && requestHdr != null && passport != null) {
            String remoteUserFromPassport = passport.getTiedRemoteUser();
            String requestRemoteUser = requestHdr.getEnvVarValue("REMOTE_USER");
            if (remoteUserFromPassport != null) {
                verify = remoteUserFromPassport.equalsIgnoreCase(requestRemoteUser);
            } else if (remoteUserFromPassport == null && requestRemoteUser != null) {
                verify = false;
            }
        }
        return verify;
    }
}

