/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import java.io.UnsupportedEncodingException;

public class SetStateInfo
extends DefaultHandler
implements ConfigurationListener {
    public static final String USER_SESSION_ID = "usersessionid";
    public static final String CEA_SSA = "cea-ssa";
    private static final String ALLOW_SESSION_SHARING_XPATH = "./*[local-name()='parameter'][@name=\"allowSessionSharing\"]/*[local-name()='value']/text()";
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String SET_STATE_INFO_CONFIGURATION_CHANGED = "SetStateInfo.configurationChanged";
    private static final String ENCODING = "UTF8";
    private CAMFactory camf;
    private Boolean allowSessionSharing = new Boolean("false");
    private TraceLogger traceLogger;

    private void clearStateInfo(BiBusHeader theHeader) {
        if (theHeader.getCAMPassportID() != null) {
            theHeader.setCookie(CAM_PASSPORT, "", -1, null, null, null);
            theHeader.setSessionContext("");
            theHeader.setCookie(CEA_SSA, this.allowSessionSharing.toString(), -1, null, null, null);
            theHeader.setCookie(USER_SESSION_ID, "", -1, null, null, null);
        }
        theHeader.setCAMPassportId(null, null);
        theHeader.setUserSessionID(null);
    }

    @Override
    public void close(MessageContext theContext) {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        BiBusHeader responseHdr = ((SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse")).getHeader().getBiBusHeader();
        if (passport != null) {
            PassportManager.getInstance().updateIfRequired(passport);
            String userSessionID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userSessionID");
            String camPassportCookie = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.camPassportCookie");
            String trackingSessionId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.trackingSessionContextId");
            this.setStateInfo(responseHdr, passport.getID(), camPassportCookie, trackingSessionId, userSessionID);
            try {
                BiBusHeader requestHdr = ((SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest")).getHeader().getBiBusHeader();
                this.updateCAFSecureState(passport.getID(), responseHdr, requestHdr);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (CAMCryptoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.clearStateInfo(responseHdr);
        }
    }

    @Override
    public void configurationChanged(Configuration theNewConfiguration) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, SET_STATE_INFO_CONFIGURATION_CHANGED);
        boolean oldAllowSessionSharing = this.allowSessionSharing;
        String value = theNewConfiguration.getOptionalValue(ALLOW_SESSION_SHARING_XPATH, Boolean.FALSE.toString());
        this.allowSessionSharing = Boolean.valueOf(value);
        LogData logData = this.traceLogger.getLogData();
        logData.addParameter("Old allow session sharing value: ", Boolean.toString(oldAllowSessionSharing));
        logData.addParameter("New allow session sharing value: ", Boolean.toString(this.allowSessionSharing));
        this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "SetStateInfo.values", logData);
        this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, SET_STATE_INFO_CONFIGURATION_CHANGED);
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{ALLOW_SESSION_SHARING_XPATH};
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        if (config instanceof ConfigurationManager) {
            ((ConfigurationManager)config).addListener(this);
        }
        this.configurationChanged(config);
        this.camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
    }

    private void setStateInfo(BiBusHeader theHeader, String thePassportID, String theCamPassportCookie, String theTrackingSessionId, String theUserSessionID) {
        String currentPassportID = theHeader.getCAMPassportID();
        if (currentPassportID == null || !currentPassportID.equals(thePassportID)) {
            theHeader.setCookie(CEA_SSA, this.allowSessionSharing.toString(), 0, null, null, null);
            if (theUserSessionID != null) {
                theHeader.setCookie(USER_SESSION_ID, theUserSessionID, 0, null, null, null);
            }
        }
        if (theCamPassportCookie != null) {
            String currentCamPassportCookie;
            try {
                currentCamPassportCookie = theHeader.getCookieValue(CAM_PASSPORT);
            }
            catch (LocalizableException e) {
                throw new RuntimeException(e);
            }
            if (currentCamPassportCookie == null || !currentCamPassportCookie.equals(theCamPassportCookie)) {
                theHeader.setCamPassportCookieInfo(theCamPassportCookie);
            }
        }
        if (theTrackingSessionId != null) {
            theHeader.setSessionContext(theTrackingSessionId);
        }
        theHeader.setCAMPassportId(thePassportID, this.allowSessionSharing);
        if (theUserSessionID != null) {
            theHeader.setUserSessionID(theUserSessionID);
        }
    }

    private void updateCAFSecureState(String newPassport, BiBusHeader responseHdr, BiBusHeader requestHdr) throws CAMCryptoException, UnsupportedEncodingException {
        SecureStateSession oldSession;
        String oldPassport = requestHdr.getCAMPassportID();
        String oldSecureState = requestHdr.getSecureState();
        if (oldPassport != null && oldSecureState != null && !(oldSession = this.camf.createSecureStateSession(oldPassport.getBytes(ENCODING), oldSecureState.getBytes(ENCODING))).verifySecureStateToken()) {
            return;
        }
        if (newPassport != null && !newPassport.equals(oldPassport)) {
            SecureStateSession newSession = this.camf.createSecureStateSession(newPassport.getBytes(ENCODING));
            newSession.setRequestExternal(false);
            newSession.setRequestValidated(true);
            responseHdr.setSecureState(new String(newSession.getSecureStateToken(), ENCODING));
        }
    }
}

