/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.TrustedToken;
import com.ibm.cognos.camaaa.internal.auth.TrustedTokenManager;
import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.HiddenDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.SystemRecoverableException;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacySoapEnvelopeResponseImpl;

public class SingleSignonFaultHandler
extends DefaultHandler {
    private static final String TRUSTED_ENVIRONMENT_TOKEN = "CAM_TOKENID_";

    @Override
    public void destroy() {
        TrustedTokenManager.destroyInstance();
    }

    @Override
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        SoapEnvelopeResponse soapEnvelopeResponse = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        SoapFault soapBodyEntry = null;
        if (soapEnvelopeResponse instanceof LegacySoapEnvelopeResponseImpl) {
            soapBodyEntry = ((LegacySoapEnvelopeResponseImpl)soapEnvelopeResponse).getFaultEntry();
        } else if (soapEnvelopeResponse instanceof SoapEnvelopeResponseImpl) {
            soapBodyEntry = ((SoapEnvelopeResponseImpl)soapEnvelopeResponse).getBody().getBodyEntry();
        }
        if (soapBodyEntry != null && soapBodyEntry.getType() == 19 && soapBodyEntry.getErrorCodeString().equals("camAuthSystemRecoverable")) {
            SystemRecoverableException exception = (SystemRecoverableException)soapBodyEntry;
            String[] requestedVars = exception.getRequestedVars();
            DisplayObject[] displayObjects = exception.getDisplayObjects();
            if (requestedVars != null && requestedVars.length > 0) {
                TrustedToken trustedToken = TrustedTokenManager.getInstance().createTrustedToken();
                String[] modifiedRequestedVars = new String[requestedVars.length + 1];
                for (int i = 0; i < requestedVars.length; ++i) {
                    modifiedRequestedVars[i] = requestedVars[i];
                }
                modifiedRequestedVars[i] = TRUSTED_ENVIRONMENT_TOKEN + trustedToken.getID();
                SystemRecoverableException modifiedException = new SystemRecoverableException(exception.getFaultActor(), exception.getLocalizableMessage(), modifiedRequestedVars, (Exception)exception.getCause());
                this.addHiddenDisplayObject(displayObjects, modifiedException);
                soapEnvelopeResponse.setFaultEntry((SoapFault)modifiedException, theContext);
            }
        }
        return true;
    }

    private void addHiddenDisplayObject(DisplayObject[] displayObjects, SystemRecoverableException modifiedException) {
        for (int j = 0; j < displayObjects.length; ++j) {
            if (!(displayObjects[j] instanceof HiddenDisplayObject)) continue;
            modifiedException.addDisplayObject((HiddenDisplayObject)displayObjects[j]);
        }
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        TrustedTokenManager trustedTokenManager = TrustedTokenManager.getInstance();
        if (!trustedTokenManager.isConfigured()) {
            Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
            trustedTokenManager.configure(config);
        }
    }
}

