/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.admin.handler.ProcessSessionQuery;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.TerminateSessionsRequest;
import com.ibm.cognos.camaaa.internal.auth.soap.TerminateSessionsResponse;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.AuditLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.Collection;
import java.util.Iterator;

public class TerminateSessions
extends DefaultHandler {
    private static final String ACTOR = TerminateSessions.class.getName();
    private final AuditLoggerImpl logger;

    public TerminateSessions() {
        LogTypedLogger typedLogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditIndication.class);
        this.logger = new AuditLoggerImpl(typedLogger);
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        SoapEnvelope request = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        TerminateSessionsRequest tsRequest = (TerminateSessionsRequest)request.getBody().getBodyEntry();
        SoapEnvelope response = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        TerminateSessionsResponse tsResponse = (TerminateSessionsResponse)response.getBody().getBodyEntry();
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        if (!passport.getRoles().contains("CAMID(\"::System Administrators\")")) {
            throw new InvalidRequestException(ACTOR, (LocalizableMessage)new Message("AAA_REQ_E_MUST_BE_SYSADMIN"));
        }
        SearchExpression se = tsRequest.getSearchExpression();
        Collection<Passport> matchingPassports = ProcessSessionQuery.getMatchingPassports(passport, se);
        Iterator<Passport> pIt = matchingPassports.iterator();
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        LogContext logContext = requestContext.getLogContext();
        if (this.logger.isEnabled(40000)) {
            LogData logData = this.logger.getLogData();
            this.logger.logSessionTerminate(logContext, ComponentImpl.getInstance(), 30000, logData, se.toString(), "Success", null);
        }
        while (pIt.hasNext()) {
            PassportImpl p = (PassportImpl)pIt.next();
            p.terminate(logContext.getRequestContext());
        }
        tsResponse.setCount(matchingPassports.size());
        return true;
    }
}

