/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.InvokeCMTask;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.RenewTCResponse;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import java.io.UnsupportedEncodingException;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class UpdateTC
extends DefaultHandler {
    private EncryptingSession session;
    private Timer timer;

    @Override
    public void destroy() {
        super.destroy();
        this.timer.cancel();
        this.timer = null;
    }

    private String encyptCredentials(Credential[] credentials) throws CAMCryptoException, UnsupportedEncodingException {
        String credentialsString = "";
        for (int i = 0; i < credentials.length; ++i) {
            credentialsString = credentialsString + ((CredentialImpl)credentials[i]).getRootElement().asXML();
        }
        if (credentials.length > 1) {
            credentialsString = "<credentials>" + credentialsString + "</credentials>";
        }
        byte[] encryptedData = this.session.encryptData(credentialsString.getBytes("UTF-8"));
        return base64.encode((int)0, (byte[])encryptedData);
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        Credential[] credentials = (Credential[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        if (credentials == null || credentials.length == 0) {
            return false;
        }
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        String primaryNsId = passport.getPrimaryNsID();
        InternalVisa primaryVisa = passport.getInternalVisa(primaryNsId);
        String camId = primaryVisa.getCAMID();
        SoapEnvelopeResponse env = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        this.updateCMTC(credentials, camId, env);
        RenewTCResponse response = (RenewTCResponse)env.getBody().getBodyEntry();
        response.setUpdated(true);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        this.timer = new Timer(true);
    }

    private void updateCMTC(Credential[] credentials, String nsId, SoapEnvelopeResponse soapEnvResponse) throws SoapFaultException {
        Element cmRequestEnvelope;
        StringBuffer credentialsBlob = new StringBuffer();
        credentialsBlob.append("<credential><encryptedValue>");
        try {
            credentialsBlob.append(this.encyptCredentials(credentials));
        }
        catch (Exception e) {
            throw new InternalErrorException(this.getClass().toString(), e);
        }
        credentialsBlob.append("</encryptedValue></credential>");
        Element cmRequestBodyElement = CMAccessor.createRequestBodyForUpdateTC(nsId, credentialsBlob.toString());
        try {
            cmRequestEnvelope = CMAccessor.createCMRequest(cmRequestBodyElement, (SoapEnvelope)soapEnvResponse);
        }
        catch (DocumentException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        InvokeCMTask task = new InvokeCMTask(cmRequestEnvelope.asXML());
        this.timer.schedule((TimerTask)task, 0L);
    }
}

