/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.handler.DispatchToNamespaceUtility;
import com.ibm.cognos.camaaa.internal.auth.handler.GenerateTCforNamespace;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.RenewTCResponse;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ValidateTC
extends DefaultHandler {
    private static boolean compareNames(Credential a, Credential b, List namesA, List namesB) {
        boolean ret = true;
        Iterator it = namesA.iterator();
        LinkedList copyOfnamesB = new LinkedList(namesB);
        while (it.hasNext()) {
            String nameA = (String)it.next();
            if (copyOfnamesB.remove(nameA)) {
                if (ValidateTC.compareValues(a.getCredentialValues(nameA), b.getCredentialValues(nameA))) continue;
                ret = false;
                break;
            }
            ret = false;
            break;
        }
        return ret;
    }

    static boolean compareTC(Credential a, Credential b) {
        List<String> namesA = Arrays.asList(a.getCredentialNames());
        List<String> namesB = Arrays.asList(b.getCredentialNames());
        if (namesA.size() == namesB.size()) {
            return ValidateTC.compareNames(a, b, namesA, namesB);
        }
        return false;
    }

    private static boolean compareValues(String[] a, String[] b) {
        List<String> valuesA = Arrays.asList(a);
        List<String> valuesB = Arrays.asList(b);
        if (valuesA.size() == valuesB.size()) {
            boolean ret = true;
            Iterator<String> it = valuesA.iterator();
            LinkedList<String> copyOfValuesB = new LinkedList<String>(valuesB);
            while (it.hasNext()) {
                String valueA = it.next();
                if (copyOfValuesB.remove(valueA)) continue;
                ret = false;
                break;
            }
            return ret;
        }
        return false;
    }

    private int getCredentialIndex(String nsId, Credential[] credentials) {
        for (int i = 0; i < credentials.length; ++i) {
            if (!nsId.equals(credentials[i].getCredentialValues("namespace")[0])) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        SoapEnvelopeResponse env = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        RenewTCResponse response = (RenewTCResponse)env.getBody().getBodyEntry();
        Credential generatedTC = (Credential)theContext.remove((Object)GenerateTCforNamespace.GENERATED_TC_KEY);
        Credential[] credentials = (Credential[])theContext.remove((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        String nsId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        response.setNamespace(nsId);
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        String primaryNsId = passport.getPrimaryNsID();
        int currentTCIndex = this.getCredentialIndex(nsId, credentials);
        boolean valid = true;
        if (currentTCIndex == -1) {
            throw new InternalErrorException(this.getClass().toString());
        }
        if (generatedTC == null) {
            valid = this.validateSSOTC(nsId, credentials[currentTCIndex], theContext);
        } else {
            if (credentials.length > 1 && primaryNsId.equals(nsId)) {
                generatedTC.addCredentialPair("primary", new String[]{"true"});
            }
            if (!(valid = ValidateTC.compareTC(generatedTC, credentials[currentTCIndex]))) {
                credentials[currentTCIndex] = generatedTC;
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)credentials);
            }
        }
        response.setValidated(valid);
        return valid;
    }

    private boolean validateSSOTC(String nsId, Credential currentTC, MessageContext context) throws SoapFaultException {
        Visa visa = DispatchToNamespaceUtility.logonTC(currentTC, nsId, context);
        DispatchToNamespaceUtility.logoff(visa, nsId, context);
        return true;
    }
}

