/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.soap;

import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.ClonePassportRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.GenerateTCRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.GetIdentityRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.HavePassportsExpiredRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.HeaderRequestConverter;
import com.ibm.cognos.camaaa.internal.auth.soap.LogoffRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonTCRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.RenewTCRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.RetrieveCredentialRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.SACAMGetIdentityRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.SelectRolesRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.SelectTenantsRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.TerminateSessionsRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.ValidateRequestImpl;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public final class AuthBodyRequest
implements SoapBody {
    static final XPath XPATH_HEADER_REQUESTS = DocumentHelper.createXPath((String)"./*[( namespace-uri()=\"http://developer.cognos.com/schemas/bibus/3/\" or namespace-uri()=\"http://developer.cognos.com/schemas/saCAMService/1\") and ( local-name()=\"logon\"or local-name()=\"logonTC\"or local-name()=\"logoff\"or local-name()=\"validate\"or local-name()=\"generateTC\"or local-name()=\"retrieveCredential\"or local-name()=\"getIdentity\"or local-name()=\"selectRoles\"or local-name()=\"havePassportsExpired\")]");
    static final XPath XPATH_BODY_REQUESTS = DocumentHelper.createXPath((String)"./SOAP-ENV:Body/*[( namespace-uri()=\"http://developer.cognos.com/schemas/bibus/3/\" or namespace-uri()=\"http://developer.cognos.com/schemas/saCAMService/1\") and ( local-name()=\"logon\"or local-name()=\"logonTC\"or local-name()=\"logoff\"or local-name()=\"validate\"or local-name()=\"generateTC\"or local-name()=\"retrieveCredential\"or local-name()=\"getIdentity\"or local-name()=\"selectRoles\"or local-name()=\"havePassportsExpired\"or local-name()=\"terminateSessions\"or local-name()=\"selectTenants\"or local-name()=\"renewTC\"or local-name()=\"clonePassport\")]");
    private static final XPath XPATH_SOAP_ENV_BODY = DocumentHelper.createXPath((String)"./SOAP-ENV:Body");
    private static final XPath XPATH_ACTION = DocumentHelper.createXPath((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='CAM']/*[local-name()='action']/text()");
    private static final int SACAM_GET_IDENTITY_REQUEST = 13;
    private static final int SELECT_TENANTS_REQUEST = 12;
    private static final int TERMINATE_SESSIONS_REQUEST = 11;
    private static final int RENEW_TC_REQUEST = 10;
    private static final int CLONE_PASSPORT_REQUEST = 9;
    private static final int HAVE_PASSPORTS_EXPIRED_REQUEST = 8;
    private static final int GET_IDENTITY_REQUEST = 7;
    private static final int RETRIEVE_CREDENTIAL_REQUEST = 6;
    private static final int GENERATE_TC_REQUEST = 5;
    private static final int SELECT_ROLES_REQUEST = 4;
    private static final int LOGOFF_REQUEST = 3;
    private static final int VALIDATE_REQUEST = 2;
    private static final int LOGON_TC_REQUEST = 1;
    private static final int LOGON_REQUEST = 0;
    private static HashMap<QName, Integer> bodyEntryTypes = new HashMap();
    private static final String COMMON_REQUESTS = "( namespace-uri()=\"http://developer.cognos.com/schemas/bibus/3/\" or namespace-uri()=\"http://developer.cognos.com/schemas/saCAMService/1\") and ( local-name()=\"logon\"or local-name()=\"logonTC\"or local-name()=\"logoff\"or local-name()=\"validate\"or local-name()=\"generateTC\"or local-name()=\"retrieveCredential\"or local-name()=\"getIdentity\"or local-name()=\"selectRoles\"or local-name()=\"havePassportsExpired\"";
    private SoapBodyEntry bodyEntry;

    private AuthBodyRequest(Element theBodyEntryElement) throws SoapFaultException {
        bodyEntryTypes.put(LogonRequestImpl.BIBUS_LOGON, new Integer(0));
        bodyEntryTypes.put(LogonTCRequestImpl.BIBUS_LOGON_TC, new Integer(1));
        bodyEntryTypes.put(ValidateRequestImpl.BIBUS_VALIDATE, new Integer(2));
        bodyEntryTypes.put(LogoffRequestImpl.BIBUS_LOGOFF, new Integer(3));
        bodyEntryTypes.put(SelectRolesRequestImpl.BIBUS_SELECT_ROLES, new Integer(4));
        bodyEntryTypes.put(GenerateTCRequestImpl.BIBUS_GENERATE_TC, new Integer(5));
        bodyEntryTypes.put(RetrieveCredentialRequestImpl.BIBUS_RETRIEVE_CREDENTIAL, new Integer(6));
        bodyEntryTypes.put(GetIdentityRequestImpl.BIBUS_GET_IDENTITY, new Integer(7));
        bodyEntryTypes.put(SACAMGetIdentityRequestImpl.SACAM_GET_IDENTITY, new Integer(13));
        bodyEntryTypes.put(HavePassportsExpiredRequestImpl.BIBUS_HAVE_PASSPORTS_EXPIRED, new Integer(8));
        bodyEntryTypes.put(ClonePassportRequestImpl.BIBUS_CLONE_PASSPORT, new Integer(9));
        bodyEntryTypes.put(RenewTCRequestImpl.BIBUS_RENEW_TC, new Integer(10));
        bodyEntryTypes.put(TerminateSessionsRequestImpl.SACAM_TERMINATE_SESSIONS, new Integer(11));
        bodyEntryTypes.put(SelectTenantsRequestImpl.SACAM_SELECT_TENANTS, new Integer(12));
        this.bodyEntry = null;
        Integer type = bodyEntryTypes.get(theBodyEntryElement.getQName());
        switch (type) {
            case 10: {
                this.bodyEntry = new RenewTCRequestImpl(theBodyEntryElement);
                break;
            }
            case 9: {
                this.bodyEntry = new ClonePassportRequestImpl(theBodyEntryElement);
                break;
            }
            case 8: {
                this.bodyEntry = new HavePassportsExpiredRequestImpl(theBodyEntryElement);
                break;
            }
            case 7: {
                this.bodyEntry = new GetIdentityRequestImpl(theBodyEntryElement);
                break;
            }
            case 13: {
                this.bodyEntry = new SACAMGetIdentityRequestImpl(theBodyEntryElement);
                break;
            }
            case 6: {
                this.bodyEntry = new RetrieveCredentialRequestImpl(theBodyEntryElement);
                break;
            }
            case 5: {
                this.bodyEntry = new GenerateTCRequestImpl(theBodyEntryElement);
                break;
            }
            case 4: {
                this.bodyEntry = new SelectRolesRequestImpl(theBodyEntryElement);
                break;
            }
            case 3: {
                this.bodyEntry = new LogoffRequestImpl(theBodyEntryElement);
                break;
            }
            case 2: {
                this.bodyEntry = new ValidateRequestImpl(theBodyEntryElement);
                break;
            }
            case 1: {
                this.bodyEntry = new LogonTCRequestImpl(theBodyEntryElement);
                break;
            }
            case 0: {
                this.bodyEntry = new LogonRequestImpl(theBodyEntryElement);
                break;
            }
            case 11: {
                this.bodyEntry = new TerminateSessionsRequestImpl(theBodyEntryElement);
                break;
            }
            case 12: {
                this.bodyEntry = new SelectTenantsRequestImpl(theBodyEntryElement);
                break;
            }
        }
    }

    public static SoapBody getSoapBody(Element theSoapEnvelopeElement) throws SoapFaultException {
        AuthBodyRequest retval = null;
        List nodes = null;
        String action = DocumentHelper.valueOf((XPath)XPATH_ACTION, (Node)theSoapEnvelopeElement);
        boolean hasEmptyBody = AuthBodyRequest.hasEmptyBody(theSoapEnvelopeElement);
        if (!hasEmptyBody && action != null && action.length() > 0) {
            throw new UnrecoverableException(AuthBodyRequest.class.toString(), (LocalizableMessage)new Message("AAA_CAP_E_MULTIPLE_REQUESTS_FOUND"), (LocalizableMessage)new Message("AAA_REQ_E_MULTIPLE_REQUESTS_FOUND"));
        }
        if (hasEmptyBody) {
            Document doc = HeaderRequestConverter.createBodyRequest(theSoapEnvelopeElement);
            nodes = DocumentHelper.selectNodes((XPath)XPATH_HEADER_REQUESTS, (Node)doc.getRootElement());
        } else {
            nodes = DocumentHelper.selectNodes((XPath)XPATH_BODY_REQUESTS, (Node)theSoapEnvelopeElement);
        }
        if (nodes == null) {
            throw new UnrecoverableException(AuthBodyRequest.class.toString(), (LocalizableMessage)new Message("AAA_CAP_E_INVALID_REQUEST"), (LocalizableMessage)new Message("AAA_REQ_E_INVALID_REQUEST"));
        }
        if (nodes.size() == 1) {
            retval = new AuthBodyRequest((Element)nodes.get(0));
        } else if (nodes.size() > 1) {
            throw new UnrecoverableException(AuthBodyRequest.class.toString(), (LocalizableMessage)new Message("AAA_CAP_E_MULTIPLE_REQUESTS_FOUND"), (LocalizableMessage)new Message("AAA_REQ_E_MULTIPLE_REQUESTS_FOUND"));
        }
        return retval;
    }

    private static boolean hasEmptyBody(Element theSoapEnvelope) {
        Element body = (Element)DocumentHelper.selectSingleNode((XPath)XPATH_SOAP_ENV_BODY, (Node)theSoapEnvelope);
        if (body == null) {
            return true;
        }
        return body.elements().isEmpty();
    }

    public SoapBodyEntry getBodyEntry() {
        return this.bodyEntry;
    }
}

