/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.soap;

import com.ibm.cognos.camaaa.internal.auth.soap.AuthBodyResponse;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Node;

public final class ConvertToHeaderResponse {
    private static final String ERRORCODE = "errorCode";
    private static final String EXCEPTION = "exception";
    private static final String MESSAGE = "message";
    private static final String MESSAGESTRING = "messageString";
    private static final String SEVERITY = "severity";
    private static final String ERROR = "error";
    private static final String BUS_EXCEPTION = "bus:exception";
    private static final String BUS_MESSAGE = "bus:message";
    private static final String XSI_TYPE = "xsi:type";

    private ConvertToHeaderResponse() {
    }

    private static void addExceptionDetailToBody(SoapEnvelopeResponseImpl theSoapEnvelope, RequestContext requestContext) {
        Element element = null;
        Element detailElement = (Element)DocumentHelper.selectSingleNode((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/SOAP-ENV:Fault/*[local-name()='detail']", (Node)theSoapEnvelope.getElement());
        Element exceptionElement = detailElement.addElement(EXCEPTION);
        exceptionElement.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        exceptionElement.addAttribute(XSI_TYPE, BUS_EXCEPTION);
        element = exceptionElement.addElement(SEVERITY);
        element.addText(ERROR);
        element = exceptionElement.addElement(ERRORCODE);
        element.addText("camHeaderFault");
        element = exceptionElement.addElement(MESSAGE);
        element.addAttribute(XSI_TYPE, BUS_MESSAGE);
        element = element.addElement(MESSAGESTRING);
        Locale theProductLocale = requestContext.getProductLocale();
        element.addText(new Message("AAA_REQ_E_ERROR_IN_HEADER").getLocalizedMessage(theProductLocale));
    }

    public static void createHeaderResponse(SoapEnvelopeResponseImpl theSoapEnvelope, RequestContext requestContext) {
        AuthBodyResponse theAuthBodyResponse;
        SoapBody theSoapBody = theSoapEnvelope.getBody();
        if (theSoapBody instanceof AuthBodyResponse && (theAuthBodyResponse = (AuthBodyResponse)theSoapBody).isResponseToHeaderRequest()) {
            ConvertToHeaderResponse.moveResponseToHeaderIfRequired(theSoapEnvelope, requestContext);
        }
    }

    private static Element getCamElement(SoapEnvelopeResponseImpl theSoapEnvelope) {
        Element camElement;
        Element bibusElement;
        Element soapEnvelope = theSoapEnvelope.getElement();
        Element hdrElement = soapEnvelope.element(XMLConstants.SOAPENV_HEADER);
        if (hdrElement == null) {
            hdrElement = soapEnvelope.addElement(XMLConstants.SOAPENV_HEADER);
        }
        if ((bibusElement = hdrElement.element(XMLConstants.BIBUS_BIBUSHEADER)) == null) {
            bibusElement = hdrElement.addElement(XMLConstants.BIBUS_BIBUSHEADER);
            bibusElement.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        if ((camElement = bibusElement.element(XMLConstants.BIBUS_CAM.getName())) == null) {
            camElement = bibusElement.addElement(XMLConstants.BIBUS_CAM.getName());
            camElement.addAttribute(XSI_TYPE, XMLConstants.BIBUS_CAM.getQualifiedName());
        }
        return camElement;
    }

    private static void moveFaultToHeader(SoapEnvelopeResponseImpl theSoapEnvelope, RequestContext requestContext) {
        Element camException = (Element)DocumentHelper.selectSingleNode((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/SOAP-ENV:Fault/*[local-name()='detail']/*[local-name()='exception']", (Node)theSoapEnvelope.getElement());
        Element camElement = ConvertToHeaderResponse.getCamElement(theSoapEnvelope);
        camElement.clearContent();
        camException.detach();
        camElement.add(camException);
        ConvertToHeaderResponse.addExceptionDetailToBody(theSoapEnvelope, requestContext);
    }

    private static void moveGenerateTCResponseToHeader(SoapEnvelopeResponseImpl theSoapEnvelope) {
        Element camCredentialPath = (Element)DocumentHelper.selectSingleNode((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/*[local-name()='generateTCResponse']/*[local-name()='CAMCredentialPath']", (Node)theSoapEnvelope.getElement());
        camCredentialPath.detach();
        Element camElement = ConvertToHeaderResponse.getCamElement(theSoapEnvelope);
        camElement.add(camCredentialPath);
        Element body = theSoapEnvelope.getElement().element("Body");
        body.clearContent();
    }

    private static void moveResponseToHeaderIfRequired(SoapEnvelopeResponseImpl theSoapEnvelope, RequestContext requestContext) {
        switch (theSoapEnvelope.getBody().getBodyEntry().getType()) {
            case 19: {
                ConvertToHeaderResponse.moveFaultToHeader(theSoapEnvelope, requestContext);
                break;
            }
            case 14: {
                ConvertToHeaderResponse.moveGenerateTCResponseToHeader(theSoapEnvelope);
                break;
            }
        }
    }
}

