/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.soap;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.GenerateTCRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogoffRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.ValidateRequestImpl;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class HeaderRequestConverter {
    private static final String ACTION_LOGOFF = "logoff";
    private static final String ACTION_LOGON = "logon";
    private static final String ACTION_LOGON_AS = "logonAs";
    private static final String ACTION_VALIDATE = "validate";
    private static final String ACTION_VALIDATE_WITH_RESPONSE = "validateWithResponse";
    private static final String ACTION_GENERATETC = "generateTC";
    private static final String ACTION_LOGONTC = "logonTC";
    private static final String SOAP_ENCODING_NS_PREFIX = "SOAP-ENC";
    private static final String BUS_LOGONOPTIONENUM = "bus:logonOptionEnum";
    private static final String BUS_XMLENCODEDXML = "bus:xmlEncodedXML";
    private static final String SOAPENC_ARRAY = "SOAP-ENC:Array";
    private static final String SOAPENC_ARRAYTYPE = "SOAP-ENC:arrayType";
    private static final String XSI_TYPE = "xsi:type";
    private static final QName SOAPENV_BODY = QName.get((String)"Body", (String)"http://schemas.xmlsoap.org/soap/envelope/");

    private HeaderRequestConverter() {
    }

    private static void addCredential(Element credentialsElement, Element credential) {
        String escapedValue = null;
        try {
            escapedValue = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.toCompactUtf8String((Element)credential, (boolean)true);
        }
        catch (SAXException e) {
            escapedValue = "<credential/>";
        }
        credentialsElement.addText(escapedValue);
    }

    private static Element addCredentials(Element logonElement) {
        Element credentialsElement = logonElement.addElement("credentials");
        credentialsElement.addAttribute(XSI_TYPE, BUS_XMLENCODEDXML);
        return credentialsElement;
    }

    private static void addCredentials(Element logonElement, List credentialList) {
        Element credentialsElement = HeaderRequestConverter.addCredentials(logonElement);
        for (int i = 0; i < credentialList.size(); ++i) {
            Element aCredential = (Element)credentialList.get(i);
            if (aCredential == null) continue;
            HeaderRequestConverter.addCredential(credentialsElement, aCredential);
        }
    }

    private static void addIgnoreAnonymousOption(Element logonElement) {
        Element logonOptionElement = logonElement.addElement("logonOptions");
        logonOptionElement.addAttribute(XSI_TYPE, SOAPENC_ARRAY);
        logonOptionElement.addAttribute(SOAPENC_ARRAYTYPE, "bus:logonOptionEnum[1]");
        Element itemElement = logonOptionElement.addElement("item");
        itemElement.addAttribute(XSI_TYPE, BUS_LOGONOPTIONENUM);
        itemElement.addText("ignoreAnonymous");
    }

    static Document createBodyRequest(Element theSoapEnvelopeElement) throws SoapFaultException {
        Document bodyRequest = null;
        Element theCAMElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='CAM']", (Node)theSoapEnvelopeElement);
        String action = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.valueOf((String)"./*[local-name()='action']/text()", (Node)theCAMElement);
        if (action == null || action.length() == 0) {
            bodyRequest = HeaderRequestConverter.createValidateRequest();
        } else if (action.equals(ACTION_VALIDATE) || action.equals(ACTION_VALIDATE_WITH_RESPONSE)) {
            bodyRequest = HeaderRequestConverter.createValidateRequest();
        } else if (action.equals(ACTION_LOGON) || action.equals(ACTION_LOGON_AS)) {
            bodyRequest = HeaderRequestConverter.createLogonRequest(action, theCAMElement);
        } else if (action.equals(ACTION_LOGOFF)) {
            bodyRequest = HeaderRequestConverter.createLogoffRequest();
        } else if (action.endsWith(ACTION_GENERATETC)) {
            bodyRequest = HeaderRequestConverter.createGenerateTCRequest();
        } else if (action.endsWith(ACTION_LOGONTC)) {
            bodyRequest = HeaderRequestConverter.createLogonRequestFromTC(theCAMElement);
        }
        return bodyRequest;
    }

    private static Document createGenerateTCRequest() {
        return HeaderRequestConverter.createRequest(GenerateTCRequestImpl.BIBUS_GENERATE_TC);
    }

    private static Document createLogoffRequest() {
        return HeaderRequestConverter.createRequest(LogoffRequestImpl.BIBUS_LOGOFF);
    }

    private static Document createLogonRequest(String action, Element theCAMElement) {
        List<Element> credentialList = null;
        Element credential = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)"./*[local-name()='credential']", (Node)theCAMElement);
        if (credential != null) {
            credentialList = new LinkedList();
            credentialList.add(credential);
        } else {
            credentialList = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectNodes((String)"./*[local-name()='credentials']/*[local-name()='credential']", (Node)theCAMElement);
        }
        return HeaderRequestConverter.createLogonRequestWithCredentials(credentialList, action);
    }

    private static Document createLogonRequestFromTC(Element camElement) throws SoapFaultException {
        try {
            Credential credential = HeaderRequestConverter.retrieveCredentialsFromTC(camElement);
            String[] names = credential.getCredentialNames();
            Element credentialElement = DocumentHelper.createElement((String)"credential");
            credentialElement.detach();
            for (int i = 0; i < names.length; ++i) {
                Element valueElement = credentialElement.addElement(names[i]);
                valueElement.setText(credential.getCredentialValue(names[i]));
            }
            LinkedList<Element> credentialList = new LinkedList<Element>();
            credentialList.add(credentialElement);
            return HeaderRequestConverter.createLogonRequestWithCredentials(credentialList, ACTION_LOGON);
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(HeaderRequestConverter.class.toString(), (Exception)((Object)e));
        }
    }

    private static Document createLogonRequestWithCredentials(List credentialList, String action) {
        Document bodyRequest = DocumentHelper.createDocument();
        Element bodyElement = bodyRequest.addElement(SOAPENV_BODY);
        Element logonElement = bodyElement.addElement(LogonRequestImpl.BIBUS_LOGON);
        if (credentialList.size() > 0) {
            HeaderRequestConverter.addCredentials(logonElement, credentialList);
        }
        if (action.equals(ACTION_LOGON_AS)) {
            HeaderRequestConverter.addIgnoreAnonymousOption(logonElement);
        }
        return bodyRequest;
    }

    private static Document createRequest(QName theRequest) {
        Document bodyRequest = DocumentHelper.createDocument();
        Element bodyElement = bodyRequest.addElement(SOAPENV_BODY);
        bodyElement.addElement(theRequest);
        return bodyRequest;
    }

    private static Document createValidateRequest() {
        return HeaderRequestConverter.createRequest(ValidateRequestImpl.BIBUS_VALIDATE);
    }

    public static String decryptData(byte[] data) throws FunctionCallFailedException {
        CAMFactory camf = new CAMFactory();
        EncryptingSession session = null;
        try {
            camf.initialize("<initializeDocument><serviceID>GetCredentialsFromTC</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(HeaderRequestConverter.class.toString(), "CAMFactory.initialize", (Exception)((Object)e));
        }
        try {
            session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(HeaderRequestConverter.class.toString(), "CAMFactory.createEncryptingSession", (Exception)((Object)e));
        }
        String decryptedData = null;
        try {
            decryptedData = new String(session.decryptData(data));
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(HeaderRequestConverter.class.toString(), "EncryptingSession.decryptData", (Exception)((Object)e));
        }
        return decryptedData;
    }

    private static Credential retrieveCredentialsFromTC(Element cam) throws InternalErrorException {
        String credentialValue = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.valueOf((String)"*[local-name()='CAMTrustedCredential']", (Node)cam);
        CredentialImpl credential = null;
        if (credentialValue.length() == 0) {
            throw new InternalErrorException(HeaderRequestConverter.class.toString(), new RuntimeException("Invalid trusted credential value on logonTC header request"));
        }
        SAXReader reader = null;
        try {
            reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(credentialValue));
            String encryptedValue = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.valueOf((String)"/*[local-name()='credential']/*[local-name()='encryptedValue']", (Node)doc.getRootElement());
            byte[] decodedValue = base64.decode((int)0, (String)encryptedValue);
            String decryptedValue = HeaderRequestConverter.decryptData(decodedValue);
            doc = reader.read((Reader)new StringReader(decryptedValue));
            credential = new CredentialImpl(doc.getRootElement());
        }
        catch (Exception e) {
            throw new InternalErrorException(HeaderRequestConverter.class.toString(), e);
        }
        return credential;
    }
}

