/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.soap;

import com.ibm.cognos.camaaa.internal.auth.TenancyInfoImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.IdentityResponse;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.tree.DefaultText;

abstract class IdentityResponseImpl
implements IdentityResponse {
    private static final QName BIBUS_READ_TENANTIDS = QName.get((String)"readTenantIDs");
    private static final QName BIBUS_SELF = QName.get((String)"self", (String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final QName BIBUS_IDENTITY = QName.get((String)"identity", (String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final QName BIBUS_TENANCY = QName.get((String)"tenancy", (String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final QName BIBUS_TENANTID = QName.get((String)"tenantID");
    private static final QName BIBUS_WRITE_TENANTID = QName.get((String)"writeTenantID");
    private static final QName BIBUS_ITEM = QName.get((String)"item");
    private static final QName ENC_ARRAY_TYPE = QName.get((String)"arrayType", (String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final QName XSI_TYPE = QName.get((String)"type", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final String COLON_STRING = ":string";
    private static final String ARRAY_STRING = ":Array";
    private static final String IS_IMPERSONATING = "isImpersonating";
    private static final String COLON_BOOLEAN = ":boolean";
    private final Element responseElement;

    IdentityResponseImpl(Element theResponseElement) {
        this.responseElement = theResponseElement;
    }

    private Element addIdentityElementIfMissing() {
        Element identityElement = this.responseElement.element(BIBUS_IDENTITY);
        if (identityElement == null) {
            identityElement = this.responseElement.addElement(BIBUS_IDENTITY);
            identityElement.addAttribute(XSI_TYPE, "bus:identity");
        }
        return identityElement;
    }

    private Element addSelfElementIfMissing(Element identityElement, int selfSize) {
        Element selfElement = identityElement.element(BIBUS_SELF);
        if (selfElement == null) {
            selfElement = identityElement.addElement(BIBUS_SELF);
            selfElement.addAttribute(XSI_TYPE, "SOAP-ENC:Array");
            selfElement.addAttribute(ENC_ARRAY_TYPE, "bus:searchPathSingleObject[" + selfSize + "]");
        }
        return selfElement;
    }

    private Element addTenancyElementIfMissing(Element identityElement) {
        Element tenancyElement = identityElement.element(BIBUS_TENANCY);
        if (tenancyElement == null) {
            tenancyElement = identityElement.addElement(BIBUS_TENANCY);
            tenancyElement.addAttribute(XSI_TYPE, "bus:tenancy");
        }
        return tenancyElement;
    }

    public String[] getIdentitySelf() {
        List list;
        String[] retval = null;
        Element identityElement = this.responseElement.element(BIBUS_IDENTITY);
        if (identityElement != null && (list = DocumentHelper.selectNodes((String)"./*[local-name()='self']/*[local-name()='item']/text()", (Node)identityElement)) != null) {
            retval = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                DefaultText text = (DefaultText)list.get(i);
                retval[i] = text.getStringValue();
            }
        }
        return retval;
    }

    public TenancyInfo getIdentityTenancy() throws SoapFaultException {
        String tenantID = null;
        String[] readTenantIDs = null;
        String writeTenantID = null;
        boolean isImpersonating = false;
        Element identityElement = this.responseElement.element(BIBUS_IDENTITY);
        if (identityElement != null) {
            List values;
            Node value = DocumentHelper.selectSingleNode((String)"./*[local-name()='tenancy']/*[local-name()='tenantID']/text()", (Node)identityElement);
            if (value != null) {
                tenantID = value.getStringValue();
            }
            if ((values = DocumentHelper.selectNodes((String)"./*[local-name()='tenancy']/*[local-name()='readTenantIDs']/*[local-name(item)='']/text()", (Node)identityElement)) != null && values.size() > 0) {
                ArrayList<String> tenantList = new ArrayList<String>();
                for (Node aNode : values) {
                    tenantList.add(aNode.getStringValue());
                }
                readTenantIDs = tenantList.toArray(new String[values.size()]);
            }
            if ((value = DocumentHelper.selectSingleNode((String)"./*[local-name()='tenancy']/*[local-name()='writeTenantID']/text()", (Node)identityElement)) != null) {
                writeTenantID = value.getStringValue();
            }
            if ((value = DocumentHelper.selectSingleNode((String)"./*[local-name()='tenancy']/*[local-name()='isImpersonating']/text()", (Node)identityElement)) != null) {
                isImpersonating = Boolean.getBoolean(value.getStringValue());
            }
        }
        TenancyInfoImpl tenancyInfo = new TenancyInfoImpl(tenantID, null, writeTenantID);
        tenancyInfo.setTenancies(TenancyInfo.TenancyType.READ_TENANTID, readTenantIDs);
        tenancyInfo.setIsImpersonating(isImpersonating);
        return tenancyInfo;
    }

    public void resetIdentity() {
        Element identityElement = this.responseElement.element(BIBUS_IDENTITY);
        if (identityElement != null) {
            this.responseElement.remove(identityElement);
        }
    }

    public void setIdentitySelf(String[] theSearchPaths) {
        Element identityElement = this.addIdentityElementIfMissing();
        Element selfElement = this.addSelfElementIfMissing(identityElement, theSearchPaths.length);
        for (int i = 0; i < theSearchPaths.length; ++i) {
            Element item = selfElement.addElement(BIBUS_ITEM);
            item.addAttribute(XSI_TYPE, "bus:searchPathSingleObject");
            item.addText(theSearchPaths[i]);
        }
    }

    public void setIdentityTenancy(TenancyInfo tenantInfo) throws SoapFaultException {
        Element identityElement = this.addIdentityElementIfMissing();
        Element tenancyElement = this.addTenancyElementIfMissing(identityElement);
        if (tenantInfo.getTenancy(TenancyInfo.TenancyType.TENANTID) != null) {
            Element tenantID = tenancyElement.addElement(BIBUS_TENANTID);
            tenantID.addAttribute(XSI_TYPE, "xsd:string");
            tenantID.addText(tenantInfo.getTenancy(TenancyInfo.TenancyType.TENANTID));
        }
        if (tenantInfo.getTenancies(TenancyInfo.TenancyType.READ_TENANTID) != null) {
            String[] theReadTenantIDs = tenantInfo.getTenancies(TenancyInfo.TenancyType.READ_TENANTID);
            Element readTenantIDs = tenancyElement.addElement(BIBUS_READ_TENANTIDS);
            readTenantIDs.addAttribute(XSI_TYPE, "SOAP-ENC:Array");
            readTenantIDs.addAttribute(ENC_ARRAY_TYPE, "xsd:string[" + theReadTenantIDs.length + "]");
            for (int i = 0; i < theReadTenantIDs.length; ++i) {
                Element readTenantID = readTenantIDs.addElement(BIBUS_ITEM);
                readTenantID.addAttribute(XSI_TYPE, "xsd:string");
                readTenantID.addText(theReadTenantIDs[i]);
            }
        }
        if (tenantInfo.getTenancy(TenancyInfo.TenancyType.WRITE_TENANTID) != null) {
            Element writeTenantID = tenancyElement.addElement(BIBUS_WRITE_TENANTID);
            writeTenantID.addAttribute(XSI_TYPE, "xsd:string");
            writeTenantID.addText(tenantInfo.getTenancy(TenancyInfo.TenancyType.WRITE_TENANTID));
        }
        Element isImpersonating = tenancyElement.addElement(IS_IMPERSONATING);
        isImpersonating.addAttribute(XSI_TYPE, "xsd:boolean");
        isImpersonating.setText(String.valueOf(tenantInfo.isImpersonating()));
    }
}

