/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.soap;

import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequest;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

public class LogonRequestImpl
implements LogonRequest {
    static final QName BIBUS_LOGON = QName.get((String)"logon", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final QName XSI_NIL = QName.get((String)"nil", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private Element logon = null;
    private Element decodedCredentials = null;

    LogonRequestImpl(Element theLogonElement) throws SoapFaultException {
        if (!theLogonElement.getQName().equals((Object)BIBUS_LOGON)) {
            return;
        }
        this.logon = theLogonElement;
        if (this.logon != null) {
            String encodedCredentials = DocumentHelper.valueOf((String)"./*[local-name()='credentials']", (Node)this.logon);
            this.decodedCredentials = LogonRequestImpl.xmlDecodeCredentials(encodedCredentials);
        }
    }

    public static Element xmlDecodeCredentials(String theEncodedCredentials) throws InternalErrorException {
        Element retval = null;
        try {
            if (theEncodedCredentials != null && theEncodedCredentials.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<credentials>");
                buffer.append(theEncodedCredentials);
                buffer.append("</credentials>");
                Document doc = DocumentHelper.parseText((String)buffer.toString());
                if (doc != null) {
                    retval = doc.getRootElement();
                }
            }
        }
        catch (DocumentException e) {
            throw new InternalErrorException(LogonRequestImpl.class.toString(), (Exception)((Object)e));
        }
        return retval;
    }

    public Credential getCredential(String theNamespaceID) {
        if (this.decodedCredentials != null) {
            Node node = DocumentHelper.selectSingleNode((String)("/*/*[*[local-name()='namespace'][camaaa:element-text(.)='" + theNamespaceID + "']]"), (Node)this.decodedCredentials);
            return this.getCredential(node);
        }
        return null;
    }

    private Credential getCredential(Node node) {
        if (node != null && node.getNodeType() == 1) {
            return new CredentialImpl((Element)node);
        }
        return null;
    }

    public Credential[] getCredentials() {
        List list;
        if (this.decodedCredentials != null && (list = this.decodedCredentials.elements()) != null && list.size() > 0) {
            Credential[] retval = new Credential[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Node node = (Node)list.get(i);
                retval[i] = this.getCredential(node);
            }
            return retval;
        }
        return null;
    }

    public String[] getOptions() {
        String[] retval = null;
        List nodes = this.logon.selectNodes("./*[local-name()='logonOptions']/*");
        if (nodes != null) {
            Element e;
            int i = 0;
            while (i < nodes.size()) {
                e = (Element)nodes.get(i);
                String strVal = e.attributeValue(XSI_NIL, Boolean.FALSE.toString());
                Boolean isNil = Boolean.valueOf(strVal);
                if (isNil.booleanValue()) {
                    nodes.remove(i);
                    continue;
                }
                ++i;
            }
            if (nodes.size() > 0) {
                retval = new String[nodes.size()];
                for (i = 0; i < nodes.size(); ++i) {
                    e = (Element)nodes.get(i);
                    retval[i] = e.getText();
                }
            }
        }
        return retval;
    }

    public String[] getRoleSelection() {
        if (this.logon == null) {
            return null;
        }
        String[] retval = null;
        Element rolesElement = (Element)DocumentHelper.selectSingleNode((String)"./*[local-name()='roles']", (Node)this.logon);
        if (rolesElement != null && !Boolean.valueOf(rolesElement.attributeValue(XMLConstants.XSI_NIL)).booleanValue()) {
            List list = DocumentHelper.selectNodes((String)"./*", (Node)rolesElement);
            if (list.size() > 0) {
                retval = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Element item = (Element)list.get(i);
                    retval[i] = item.getText();
                }
            } else {
                retval = new String[]{};
            }
        }
        return retval;
    }

    public int getType() {
        return 2;
    }
}

