/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import java.io.UnsupportedEncodingException;

public class EncryptionManager {
    private static final String UTF_8 = "UTF-8";
    private EncryptingSession session;
    private final LogTypedLogger logger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditIndication.class);

    public EncryptionManager() {
        try {
            CAMFactory factory = new CAMFactory();
            factory.initialize("<initializeDocument><serviceID>EncryptionManager</serviceID></initializeDocument>".getBytes());
            this.session = factory.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            this.session = null;
            this.logger.fatal((Throwable)e);
            throw new RuntimeException("CAMCrypto initialize failed", e);
        }
    }

    public synchronized byte[] encryptData(String valueToEncrypt) throws CAMCryptoException {
        try {
            if (valueToEncrypt != null) {
                return this.session.encryptData(valueToEncrypt.getBytes(UTF_8));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public synchronized String decryptData(byte[] bytes) throws CAMCryptoException {
        try {
            byte[] usernameDecrypted = this.session.decryptData(bytes);
            return new String(usernameDecrypted, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

