/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common;

import com.cognos.CAM_AAA.authentication.IBiBusHeader;
import com.ibm.cognos.camaaa.internal.auth.EnvironmentSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlobManager;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import java.util.ArrayList;
import java.util.Locale;

public class IBiBusHeaderCompatibilityAdapter
implements IBiBusHeader {
    private final BiBusHeader biBusHeader;
    private final RequestContext requestContext;
    private final Credential[] credentials;
    private final int numberOfCredential;
    private final MessageContext messageContext;
    private BiBusHeader responseBiBusHeader;

    public IBiBusHeaderCompatibilityAdapter(BiBusHeader theBiBusHeader, MessageContext theMessageContext) {
        this.biBusHeader = theBiBusHeader;
        this.requestContext = (RequestContext)theMessageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        this.credentials = (Credential[])theMessageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        this.messageContext = theMessageContext;
        this.numberOfCredential = this.credentials != null ? this.credentials.length : 0;
    }

    public void consumeFormField(String theName) {
        this.biBusHeader.consumeFormField(theName);
        this.getResponseBiBusHeader().consumeFormField(theName);
    }

    public Locale getContentLocale() {
        return this.requestContext.getContentLocale();
    }

    public String[] getCookieValue(String theName) {
        return this.biBusHeader.getCookieValues(theName);
    }

    public String[] getCredentialValue(String theName) {
        ArrayList<String> allCredentials = new ArrayList<String>();
        for (int i = 0; i < this.numberOfCredential; ++i) {
            String[] srcCredential = this.credentials[i].getCredentialValues(theName);
            for (int j = 0; j < srcCredential.length; ++j) {
                allCredentials.add(srcCredential[j]);
            }
        }
        if (allCredentials.size() == 0) {
            return null;
        }
        return allCredentials.toArray(new String[allCredentials.size()]);
    }

    public String[] getEnvVarValue(String theName) {
        return this.biBusHeader.getEnvVarValues(theName);
    }

    public String[] getFormFieldValue(String theName) {
        return this.biBusHeader.getFormFieldValues(theName);
    }

    public Locale getProductLocale() {
        return this.requestContext.getProductLocale();
    }

    public String[] getTrustedEnvVarValue(String theName) {
        String[] retval = new String[1];
        String blobString = this.biBusHeader.getCAMSecurityBlob();
        if (blobString == null || theName == null) {
            return null;
        }
        SecurityBlob securityBlob = SecurityBlobManager.createSecurityBlob(blobString);
        if (securityBlob != null && securityBlob.getBlobType() == 1) {
            String val;
            EnvironmentSecurityBlob envSecurityBlob = (EnvironmentSecurityBlob)securityBlob;
            retval[0] = val = envSecurityBlob.getRequestedVarValue(theName);
        }
        return retval;
    }

    public void setCookie(String theName, String theValue, int theMaxAge, String thePath, String theDomain, boolean theSecureFlag) {
        Boolean theSecureFlagBoolean = new Boolean(theSecureFlag);
        this.biBusHeader.setCookie(theName, theValue, theMaxAge, thePath, theDomain, theSecureFlagBoolean);
        this.getResponseBiBusHeader().setCookie(theName, theValue, theMaxAge, thePath, theDomain, theSecureFlagBoolean);
    }

    private BiBusHeader getResponseBiBusHeader() {
        if (this.responseBiBusHeader == null) {
            SoapEnvelopeResponse responseEnv = (SoapEnvelopeResponse)this.messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
            SoapHeader responseHdr = responseEnv.getHeader();
            this.responseBiBusHeader = responseHdr.getBiBusHeader();
        }
        return this.responseBiBusHeader;
    }
}

