/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContextImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponseImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyRequestContextImpl;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.dom4j.Element;

public class MessageContextImpl
extends HashMap
implements MessageContext {
    public static final String PASSPORT = "com.ibm.cognos.camaaa.internal.common.handler.message.passport";
    public static final String LOGON_IDENTITY = "com.ibm.cognos.camaaa.internal.common.handler.message.logonIdentity";
    public static final String LOGON_ROLES = "com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles";
    public static final String COGNOS_IDENTITY = "com.ibm.cognos.camaaa.internal.common.handler.message.cognosIdentity";
    public static final String USER_INFO_QUERY_RESULT = "com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult";
    public static final String PASSPORT_ID = "com.ibm.cognos.camaaa.internal.common.handler.message.passportID";
    public static final String HANDLER_BINDING = "com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding";
    public static final String TARGET_NAMESPACE = "com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace";
    public static final String TARGET_NAMESPACE_OBJECT = "com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject";
    public static final String EVENT_LOG_DATA = "com.ibm.cognos.camaaa.internal.common.handler.message.logData";
    public static final String EVENT_TYPE = "com.ibm.cognos.camaaa.internal.common.handler.message.eventType";
    public static final String EVENT_STATUS = "com.ibm.cognos.camaaa.internal.common.handler.message.eventStatus";
    public static final PassportExpireEvent PASSPORT_EXPIRED_EVENT = PassportExpireEvent.LOGONEXPIRED;
    public static final String SOAP_FAULT = "com.ibm.cognos.camaaa.internal.common.handler.message.soapFault";
    public static final String AVAILABLE_NAMESPACES = "com.ibm.cognos.camaaa.internal.common.handler.message.availableNamespaces";
    public static final String REQUEST_IS_BOUNDED_TO_NAMESPACES = "com.ibm.cognos.camaaa.internal.common.handler.message.requestIsBoundedToNamespaces";
    public static final String CREDENTIALS = "com.ibm.cognos.camaaa.internal.common.handler.message.credentials";
    public static final String USER_SESSION_ID = "com.ibm.cognos.camaaa.internal.common.handler.message.userSessionID";
    public static final String SOAP_ACTION = "com.ibm.cognos.camaaa.internal.common.handler.message.soapAction";
    public static final String AUTH_REDIRECT_REQUEST = "com.ibm.cognos.camaaa.internal.auth.AuthRedirectRequest";
    public static final String CAM_PASSPORT_COOKIE = "com.ibm.cognos.camaaa.internal.common.handler.message.camPassportCookie";
    public static final String TRACKING_SESSION_CONTEXT_ID = "com.ibm.cognos.camaaa.internal.common.handler.message.trackingSessionContextId";
    public static final String REDIRECTION_NS = "com.ibm.cognos.camaaa.internal.common.handler.message.redirectionNamespaceId";
    public static final String TENANTED_QUERY = "com.ibm.cognos.camaaa.internal.admin.soap.TenantedQuery";
    public static final String TENANT_ID = "com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID";
    public static final String WRITE_TENANT_ID = "com.ibm.cognos.camaaa.internal.multitenacy.handler.writeTenantID";
    public static final String READ_TENANT_IDS = "com.ibm.cognos.camaaa.internal.multitenacy.handler.readTenantID";
    public static final String BOUNDING_TENANT_IDS = "com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds";
    public static final String SELECT_TENANTS_READ_TENANT_ID = "com.ibm.cognos.camaaa.internal.multitenacy.handler.selectTenantsReadTenantIDs";
    public static final String SELECT_TENANTS_WRITE_TENANT_ID = "com.ibm.cognos.camaaa.internal.multitenacy.handler.selectTenantsWriteTenantID";
    public static final String TENANCY_HAS_BEEN_CLONED = "com.ibm.cognos.camaaa.internal.multitenancy.handler.tenancyHasBeenCloned";
    public static final String SEARCH_EXPRESSION = "com.ibm.cognos.camaaa.internal.admin.searchPath";
    public static final String PROPERTIES = "com.ibm.cognos.camaaa.internal.admin.properties";
    public static final String LOG_TYPED_LOGGER_NAME = " com.cognos.indications.LogTypedLogger.NAME";
    public static final String SEARCH_TARGET_NAMESPACE = "com.ibm.cognos.camaaa.internal.admin.searchTargetNamespace";
    private static final long serialVersionUID = 3268577211036359843L;
    private final Stack<String> contextKey;
    private final Set<String> keysToLog = new HashSet<String>();

    public MessageContextImpl() {
        this.contextKey = new Stack();
        this.put("com.ibm.cognos.camaaa.internal.common.handler.message.outbound", Boolean.FALSE);
    }

    public MessageContextImpl(Element theSoapEnvelope) throws SoapFaultException {
        this();
        RequestContextImpl requestContext = new RequestContextImpl(theSoapEnvelope);
        this.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest", new SoapEnvelopeRequestImpl(theSoapEnvelope));
        this.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse", new SoapEnvelopeResponseImpl(theSoapEnvelope, requestContext));
        this.put("com.ibm.cognos.camaaa.internal.common.handler.message.requestContext", requestContext);
    }

    private MessageContextImpl(SoapEnvelopeRequestImpl theSoapEnvelope, RequestContext theRequestContext, String soapAction) throws SoapFaultException {
        this();
        Object requestContext = theRequestContext != null ? new RequestContextImpl(theRequestContext) : (soapAction != null && soapAction.endsWith("CAM.legacy") ? new LegacyRequestContextImpl(theSoapEnvelope.getElement()) : new RequestContextImpl(theSoapEnvelope.getElement()));
        this.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest", theSoapEnvelope);
        this.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse", new SoapEnvelopeResponseImpl(theSoapEnvelope.getElement(), (RequestContext)requestContext));
        this.put("com.ibm.cognos.camaaa.internal.common.handler.message.requestContext", requestContext);
    }

    public MessageContext createMessageContextForNewRequest(String theBodyRequest) throws SoapFaultException {
        SoapEnvelopeRequest env = (SoapEnvelopeRequest)this.get("com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapEnvelopeRequestImpl newRequest = (SoapEnvelopeRequestImpl)env.createNewRequest(theBodyRequest);
        MessageContextImpl newContext = new MessageContextImpl(newRequest, (RequestContext)this.get("com.ibm.cognos.camaaa.internal.common.handler.message.requestContext"), (String)this.get(SOAP_ACTION));
        this.propagateKey(HANDLER_BINDING, newContext);
        this.propagateKey(SOAP_ACTION, newContext);
        this.propagateKey(PASSPORT, newContext);
        this.propagateKey(PASSPORT_ID, newContext);
        this.propagateKey(TARGET_NAMESPACE, newContext);
        this.propagatePassportExpiredEvent(newContext);
        return newContext;
    }

    @Override
    public Object get(Object key) {
        this.logKey(key);
        return super.get(key);
    }

    public String getContextKey() {
        if (this.contextKey.empty()) {
            return "";
        }
        return this.contextKey.peek();
    }

    public Object getLocal(String theKey) {
        return this.get(this.getLocalContextKey(theKey));
    }

    String getLocalContextKey(String theKey) {
        StringWriter sw = new StringWriter();
        sw.append(this.getContextKey());
        sw.append('.');
        sw.append(theKey);
        return sw.toString();
    }

    private void logKey(Object key) {
        if (key instanceof String) {
            this.keysToLog.add((String)key);
        }
    }

    public void popContextKey() {
        this.contextKey.pop();
    }

    public void populateLogData(LogData theLogData) {
        for (String key : this.keysToLog) {
            Object objValue = this.get(key);
            if (objValue == null) {
                theLogData.addParameter(key, null);
                continue;
            }
            if (objValue instanceof SoapEnvelope) {
                theLogData.addParameter(key, ((SoapEnvelope)objValue).toLoggableXML());
                continue;
            }
            if (objValue instanceof Credential) {
                theLogData.addParameter(key, "xxxx");
                continue;
            }
            theLogData.addParameter(key, objValue.toString());
        }
    }

    private void propagateKey(String theKeyName, MessageContextImpl theTargetMC) {
        if (this.containsKey(theKeyName)) {
            theTargetMC.put(theKeyName, this.get(theKeyName));
        }
    }

    private void propagatePassportExpiredEvent(MessageContextImpl theTargetMC) {
        if (this.containsKey((Object)PASSPORT_EXPIRED_EVENT)) {
            theTargetMC.put((Object)PASSPORT_EXPIRED_EVENT, this.get((Object)PASSPORT_EXPIRED_EVENT));
        }
    }

    public void pushContextKey(String theContextID) {
        this.contextKey.push(this.getContextKey() + "." + theContextID);
    }

    @Override
    public Object put(Object key, Object value) {
        this.logKey(key);
        return super.put(key, value);
    }

    public Object putLocal(String theKey, Object theValue) {
        return this.put(this.getLocalContextKey(theKey), theValue);
    }

    @Override
    public Object remove(Object key) {
        this.logKey(key);
        return super.remove(key);
    }

    public Object removeLocal(String theKey) {
        return this.remove(this.getLocalContextKey(theKey));
    }

    public void unlockPassports() {
        Passport currentPassport = (Passport)this.get(PASSPORT);
        if (currentPassport != null) {
            currentPassport.unlock();
        }
    }

    public static enum PassportExpireEvent {
        LOGONEXPIRED,
        FORCEDLOGOFF;

    }
}

