/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common;

import com.ibm.cognos.camaaa.internal.admin.common.QueryCMForNSInitialization;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.NamespaceImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerDispatcher;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactoryImpl;
import com.ibm.cognos.camaaa.internal.common.util.CAMEncoder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

class NamespaceInfo {
    static final int AVAILABLE = 1;
    static final int SUPPORTS_QUERY = 2;
    static final int SELECTABLE_FOR_AUTHENTICATION = 3;
    static final int PRIMARY_RENEW_TC = 4;
    static final int SECONDARY_RENEW_TC = 5;
    private static final String COGNOS = "Cognos";
    private static final String[] LEGACY_PROVIDERS = new String[]{"ActiveDirectory", "LDAP", "LDAP_AD", "LDAP_IBM", "LDAP_SUNONE", "NTLM", "SAP", "SiteMinder"};
    private static final List<String> LEGACY_PROVIDER_LIST = Arrays.asList(LEGACY_PROVIDERS);
    private static final String[] LEGACY_32BIT_PROVIDERS = new String[]{"Series7"};
    private static final List<String> LEGACY_32BIT_PROVIDER_LIST = Arrays.asList(LEGACY_32BIT_PROVIDERS);
    private Namespace namespace;
    private HandlerDispatcher binding;
    private Configuration configuration;
    private final BitSet status;
    private final QueryCMForNSInitialization queryCM;

    NamespaceInfo(Namespace theNamespace, HandlerDispatcher theBinding, QueryCMForNSInitialization theQueryCM) throws LocalizableException {
        this(null, theQueryCM);
        this.namespace = theNamespace;
        this.binding = theBinding;
    }

    NamespaceInfo(Configuration theConfiguration, QueryCMForNSInitialization theQueryCM) {
        this.configuration = theConfiguration;
        this.queryCM = theQueryCM;
        this.status = new BitSet();
    }

    static NamespaceInfo createSpecialSeries7Namepace(String theNamespaceID, HandlerDispatcher theNamespaceBinding, QueryCMForNSInitialization theQueryCM) throws LocalizableException {
        NamespaceInfo nsInfo = null;
        if (theNamespaceBinding != null) {
            SearchPathImpl nsSearchPath = new SearchPathImpl(theNamespaceID, null);
            NamespaceImpl namespace = new NamespaceImpl(nsSearchPath, "Series7");
            namespace.addName(null, theNamespaceID);
            nsInfo = new NamespaceInfo(namespace, theNamespaceBinding, theQueryCM);
            nsInfo.getStatus().set(1);
        }
        return nsInfo;
    }

    HandlerDispatcher getHandlerBinding() {
        return this.binding;
    }

    private String getHandlerChainFileFor(String theProviderType, Configuration config) {
        StringBuffer path = new StringBuffer();
        if (LEGACY_PROVIDER_LIST.contains(theProviderType)) {
            path.append("LPS");
        } else if (LEGACY_32BIT_PROVIDER_LIST.contains(theProviderType)) {
            path.append("LPS32");
        } else if (theProviderType.startsWith("OIDC_") || theProviderType.startsWith("TSP_OIDC_")) {
            path.append("OIDC");
        } else {
            path.append(theProviderType);
        }
        path.append("_handler_config.xml");
        return path.toString();
    }

    Namespace getNamespace() {
        return this.namespace;
    }

    BitSet getStatus() {
        return this.status;
    }

    final Configuration getConfiguration() {
        return this.configuration;
    }

    void initBinding(NamespaceManager theNamespaceManager) throws LocalizableException {
        String providerType = this.namespace.getProviderType();
        if (providerType.equals(COGNOS)) {
            this.binding = null;
            this.status.set(2);
            return;
        }
        try {
            HandlerFactoryImpl handlerFactory = new HandlerFactoryImpl(theNamespaceManager);
            this.binding = new HandlerDispatcher(handlerFactory);
            this.binding.init(this.getHandlerChainFileFor(providerType, this.configuration), this.configuration);
            this.status.set(1);
            this.status.set(2);
        }
        catch (LocalizableException e) {
            this.binding = null;
            throw e;
        }
    }

    void initNamespace(BaseClass[] nsAncestors) throws LocalizableException {
        String namespaceID = "";
        String providerType = this.configuration.getMandatoryValue("./@class");
        String name = this.configuration.getMandatoryValue("./@name");
        String selectableForAuth = this.configuration.getOptionalValue("./*[local-name()='parameter'][@name='selectableForAuth']/*[local-name()='value']/text()", Boolean.TRUE.toString());
        String renewTCPrimaryNs = this.configuration.getOptionalValue("./*[local-name()='parameter'][@name='renewTCForPrimaryNs']/*[local-name()='value']/text()", Boolean.TRUE.toString());
        String renewTCSecondaryNs = this.configuration.getOptionalValue("./*[local-name()='parameter'][@name='renewTCForSecondaryNs']/*[local-name()='value']/text()", Boolean.FALSE.toString());
        boolean isCognosNs = providerType.equals(COGNOS);
        if (!isCognosNs) {
            namespaceID = this.configuration.getMandatoryValue("./*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()");
            namespaceID = CAMEncoder.encodeQuote((String)namespaceID);
        }
        SearchPathImpl nsSearchPath = new SearchPathImpl(namespaceID, null);
        this.namespace = new NamespaceImpl(nsSearchPath, providerType);
        this.namespace.addName(null, this.translateNameIfNeeded(name));
        if (Boolean.valueOf(selectableForAuth).booleanValue()) {
            this.status.set(3);
        }
        if (Boolean.valueOf(renewTCPrimaryNs).booleanValue()) {
            this.status.set(4);
        }
        if (Boolean.valueOf(renewTCSecondaryNs).booleanValue()) {
            this.status.set(5);
        }
        this.namespace.setAncestors(nsAncestors);
        if (isCognosNs) {
            this.namespace.setCapabilities(new String[]{"contains", "equals", "startsWith", "sort"});
        }
        String namespaceFormat = this.queryCM == null ? "http://developer.cognos.com/schemas/CAM/AAANamespaceFormat/3/" : this.queryCM.retrieveNamespaceFormatFromCM(namespaceID);
        this.namespace.setNamespaceFormat(namespaceFormat);
    }

    private String translateNameIfNeeded(String orgName) {
        String from = System.getProperty("com.ibm.cognos.camaaa.internal.common.NamespaceInfo.replaceFrom", "(?i)\\bCognosEx\\b");
        String to = System.getProperty("com.ibm.cognos.camaaa.internal.common.NamespaceInfo.replaceTo", COGNOS);
        return orgName.replaceAll(from, to);
    }

    void setBinding(HandlerDispatcher theBinding) {
        this.binding = theBinding;
    }
}

