/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.DirectoryImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.common.NamespaceInfo;
import com.ibm.cognos.camaaa.internal.common.NamespaceManagerImpl;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.Map;

public class NamespaceManagerForTest
extends NamespaceManagerImpl {
    private static final String ID_XPATH = "./*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()";
    private static final String INSTANCES_XPATH = "./*[local-name()='instances'][@name='authProvider']/*[local-name()='instance' and ./*[local-name()='parameter' and @name='id']]";

    public NamespaceManagerForTest() {
        super(null);
    }

    private void checkForMultipleNSs(String id, boolean tested) throws LocalizableException {
        if (tested) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_MULTIPLE_NS_ID", (Object[])new String[]{id}));
        }
    }

    @Override
    protected void handleException(Namespace namespace, LocalizableException e) throws LocalizableException {
        super.handleException(namespace, e);
        throw e;
    }

    public void init(Configuration config, String id) throws LocalizableException {
        Configuration[] instances = config.getConfiguration(INSTANCES_XPATH);
        boolean tested = false;
        if (instances != null) {
            for (Configuration instanceConfig : instances) {
                if (!instanceConfig.getMandatoryValue(ID_XPATH).equalsIgnoreCase(id)) continue;
                this.checkForMultipleNSs(id, tested);
                DirectoryImpl commonAncestor = new DirectoryImpl();
                commonAncestor.addName(null, "Directory");
                this.createNamespace(instanceConfig, new BaseClass[]{commonAncestor}, false);
                tested = true;
            }
        }
        if (!tested) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_INVALID_NS_ID", (Object[])new String[]{id}));
        }
    }

    public Map<String, String> getConformancePropertiesForNamespace(String id) throws LocalizableException {
        Namespace namespace = this.getNamespace(id);
        if (namespace == null) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_INVALID_NS_ID", (Object[])new String[]{id}));
        }
        return namespace.getConformanceProperties();
    }

    @Override
    public synchronized void init(Configuration config) throws LocalizableException {
        throw new RuntimeException("init(Configuration) not suported by this class");
    }

    @Override
    protected void destroyNamespace(NamespaceInfo nsInfo) {
        try {
            super.destroyNamespace(nsInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        this.destroyAllNamespaces();
    }
}

