/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.admin.common.QueryCMForNSInitialization;
import com.ibm.cognos.camaaa.internal.admin.common.QueryCMForNSInitializationImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Directory;
import com.ibm.cognos.camaaa.internal.admin.soap.DirectoryImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.common.NamespaceInfo;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerDispatcher;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.util.CAMEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class NamespaceManagerImpl
implements NamespaceManager,
ConfigurationListener {
    static final String CAM_AAA_AUTH_SERIES7 = "$CAM_AAA_AuthSeries7";
    private static final String NAMESPACE_ID = "Namespace ID";
    private static final String NAMESPACE_MANAGER_CONFIGURATION_CHANGED = "NamespaceManager.configurationChanged";
    private static final String AUTH_PROVIDER_INSTANCE = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']";
    private static NamespaceManagerImpl instance;
    private final HashMap<String, NamespaceInfo> namespaces = new HashMap();
    private final LogTypedLogger auditLogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditIndication.class);
    private final TraceLogger traceLogger;
    private final QueryCMForNSInitialization queryCM;
    private Directory commonAncestor;
    private int refCount;

    public NamespaceManagerImpl() throws LocalizableException {
        this(new QueryCMForNSInitializationImpl());
    }

    public NamespaceManagerImpl(QueryCMForNSInitialization theQueryCM) {
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
        this.queryCM = theQueryCM;
        this.refCount = 0;
    }

    public static synchronized NamespaceManagerImpl getInstance() throws LocalizableException {
        if (instance == null) {
            instance = new NamespaceManagerImpl();
        }
        return instance;
    }

    public static synchronized NamespaceManagerImpl getInstance(QueryCMForNSInitialization theQueryCM) throws LocalizableException {
        if (instance == null) {
            instance = new NamespaceManagerImpl(theQueryCM);
        }
        return instance;
    }

    public static synchronized void destroyInstance() {
        if (instance != null) {
            instance.destroy();
            if (NamespaceManagerImpl.instance.refCount == 0) {
                instance = null;
            }
        }
    }

    @Override
    public synchronized void configurationChanged(Configuration theNewConfiguration) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, NAMESPACE_MANAGER_CONFIGURATION_CHANGED);
        Configuration[] namespaceConfig = theNewConfiguration.getConfiguration(AUTH_PROVIDER_INSTANCE);
        if (namespaceConfig != null && namespaceConfig.length > 0) {
            if (this.commonAncestor == null) {
                if (this.queryCM == null) {
                    this.commonAncestor = new DirectoryImpl();
                    this.commonAncestor.addName(null, "Directory");
                } else {
                    try {
                        this.commonAncestor = this.queryCM.createAncestorDirectory();
                    }
                    catch (LocalizableException e) {
                        this.commonAncestor = new DirectoryImpl();
                        this.commonAncestor.addName(null, "Directory");
                    }
                }
            }
            HashSet<String> originalNamespaces = new HashSet<String>(this.namespaces.keySet());
            originalNamespaces.remove(CAM_AAA_AUTH_SERIES7);
            for (int i = 0; i < namespaceConfig.length; ++i) {
                LogData logData = this.traceLogger.getLogData();
                String namespaceID = "";
                try {
                    String providerType = namespaceConfig[i].getMandatoryValue("./@class");
                    boolean isCognosNs = providerType.equals("Cognos");
                    if (!isCognosNs) {
                        namespaceID = namespaceConfig[i].getMandatoryValue("./*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()");
                        namespaceID = CAMEncoder.encodeQuote((String)namespaceID);
                    }
                    if (!this.namespaces.containsKey(namespaceID)) {
                        this.createNamespace(namespaceConfig[i], new BaseClass[]{this.commonAncestor}, true);
                        logData.addParameter(NAMESPACE_ID, namespaceID);
                        this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "NamespaceManager.createNamespace", logData);
                        continue;
                    }
                    originalNamespaces.remove(namespaceID);
                    if (!this.namespaceConfigurationHasChanged(namespaceConfig[i], namespaceID)) continue;
                    try {
                        this.deleteConfiguredNamespace(namespaceID);
                    }
                    catch (LocalizableException e) {
                        LogData logDataException = this.traceLogger.getLogData();
                        logDataException.setException((Exception)((Object)e));
                        this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "NamespaceManager.changeNamespace.delete", logDataException);
                    }
                    this.createNamespace(namespaceConfig[i], new BaseClass[]{this.commonAncestor}, true);
                    logData.addParameter(NAMESPACE_ID, namespaceID);
                    this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "NamespaceManager.changeNamespace", logData);
                    continue;
                }
                catch (LocalizableException e1) {
                    logData.setException((Exception)((Object)e1));
                    this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, NAMESPACE_MANAGER_CONFIGURATION_CHANGED, logData);
                }
            }
            if (!originalNamespaces.isEmpty()) {
                for (String aDelNamespace : originalNamespaces) {
                    LogData logData = this.traceLogger.getLogData();
                    try {
                        this.deleteConfiguredNamespace(aDelNamespace);
                        logData.addParameter(NAMESPACE_ID, aDelNamespace);
                    }
                    catch (LocalizableException e) {
                        logData.setException((Exception)((Object)e));
                    }
                    this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "NamespaceManager.deleteNamespace", logData);
                }
            }
        }
        this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, NAMESPACE_MANAGER_CONFIGURATION_CHANGED);
    }

    protected void createNamespace(Configuration nsConfig, BaseClass[] nsAncestors, boolean callCMWithAdd) throws LocalizableException {
        NamespaceInfo info = new NamespaceInfo(nsConfig, this.queryCM);
        info.initNamespace(nsAncestors);
        Namespace namespace = info.getNamespace();
        String namespaceID = namespace.getSearchPath().getNamespaceID();
        this.namespaces.put(namespaceID, info);
        try {
            NamespaceInfo nsInfo;
            info.initBinding(this);
            if (namespace.getProviderType().equals("Series7") && !this.namespaces.containsKey(CAM_AAA_AUTH_SERIES7) && (nsInfo = NamespaceInfo.createSpecialSeries7Namepace(CAM_AAA_AUTH_SERIES7, info.getHandlerBinding(), this.queryCM)) != null) {
                this.namespaces.put(CAM_AAA_AUTH_SERIES7, nsInfo);
            }
            if (this.queryCM != null && callCMWithAdd) {
                this.queryCM.addNamespaceToCM(namespaceID, namespace.getName(null), namespace.getNamespaceFormat(), namespace.getCapabilities());
            }
        }
        catch (LocalizableException e) {
            this.handleException(namespace, e);
            this.destroyNamespace(info);
            this.namespaces.remove(namespaceID);
            throw e;
        }
    }

    private void deleteConfiguredNamespace(String aDelNamespace) throws LocalizableException {
        this.namespaces.get(aDelNamespace).getStatus().clear(1);
        PassportManager.getInstance().terminateSessions(passport -> passport.getAuthenticatedNamespaceIDs().contains(aDelNamespace));
        this.destroyNamespace(this.namespaces.get(aDelNamespace));
        this.namespaces.remove(aDelNamespace);
        if (this.queryCM != null) {
            this.queryCM.deleteNamespaceFromCM(aDelNamespace);
        }
    }

    public void destroy() {
        if (this.refCount == 1) {
            this.destroyAllNamespaces();
        }
        --this.refCount;
    }

    protected void destroyAllNamespaces() {
        Collection<NamespaceInfo> nsCollection = this.namespaces.values();
        for (NamespaceInfo nsInfo : nsCollection) {
            this.destroyNamespace(nsInfo);
        }
        this.namespaces.clear();
    }

    protected void destroyNamespace(NamespaceInfo nsInfo) {
        HandlerDispatcher binding = nsInfo.getHandlerBinding();
        if (binding != null) {
            binding.destroy();
        }
    }

    private Namespace[] filterAvailableNS(int filter) {
        HashSet<Namespace> nsIDs = new HashSet<Namespace>();
        for (NamespaceInfo nsInfo : this.namespaces.values()) {
            if (!nsInfo.getStatus().get(1) || !nsInfo.getStatus().get(filter)) continue;
            nsIDs.add(nsInfo.getNamespace());
        }
        return nsIDs.toArray(new Namespace[nsIDs.size()]);
    }

    private void generateIPFIndication(Namespace theNamespace, Exception theException) {
        if (this.auditLogger.isEnabled(50000)) {
            Component component = ComponentImpl.getInstance();
            LogAuditAccessIndication indication = new LogAuditAccessIndication(component.getID(), component.getBuildNumber());
            indication.setLevel(50000);
            indication.setOperation("StartService");
            indication.setObjectType("NameSpace");
            indication.setObjectPath(theNamespace.getSearchPath().getValue());
            indication.setStatus("Warning");
            LogDataImpl logData = new LogDataImpl();
            logData.init();
            logData.setException(theException);
            indication.setErrorMessage(theException.getLocalizedMessage());
            indication.setLogData(logData.toString());
            this.auditLogger.log((Object)indication);
        }
    }

    @Override
    public Namespace[] getAuthenticationNamespaces() {
        HashSet<Namespace> nsIDs = new HashSet<Namespace>();
        for (NamespaceInfo nsInfo : this.namespaces.values()) {
            if (!nsInfo.getStatus().get(1)) continue;
            nsIDs.add(nsInfo.getNamespace());
        }
        return nsIDs.toArray(new Namespace[nsIDs.size()]);
    }

    @Override
    public Namespace[] getBrowseableNamespaces() {
        HashSet<Namespace> nsIDs = new HashSet<Namespace>();
        for (NamespaceInfo nsInfo : this.namespaces.values()) {
            if (!nsInfo.getStatus().get(2)) continue;
            nsIDs.add(nsInfo.getNamespace());
        }
        return nsIDs.toArray(new Namespace[nsIDs.size()]);
    }

    @Override
    public Namespace getNamespace(String theNamespaceID) {
        NamespaceInfo nsInfo = this.namespaces.get(theNamespaceID);
        if (nsInfo != null) {
            return nsInfo.getNamespace();
        }
        return null;
    }

    @Override
    public HandlerBinding getNamespaceBinding(String theNamespaceID) {
        NamespaceInfo nsInfo = this.namespaces.get(theNamespaceID);
        if (nsInfo != null) {
            return nsInfo.getHandlerBinding();
        }
        return null;
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{AUTH_PROVIDER_INSTANCE};
    }

    @Override
    public Namespace[] getRenewTCPrimaryNamespaces() {
        return this.filterAvailableNS(4);
    }

    @Override
    public Namespace[] getRenewTCSecondaryNamespaces() {
        return this.filterAvailableNS(5);
    }

    @Override
    public Namespace[] getSelectableAuthenticationNamespaces() {
        return this.filterAvailableNS(3);
    }

    protected void handleException(Namespace namespace, LocalizableException e) throws LocalizableException {
        this.generateIPFIndication(namespace, (Exception)((Object)e));
    }

    public synchronized void init(Configuration config) throws LocalizableException {
        if (this.refCount++ > 0) {
            return;
        }
        if (config instanceof ConfigurationManager) {
            ((ConfigurationManager)config).addListener(this);
        }
        this.configurationChanged(config);
    }

    private boolean namespaceConfigurationHasChanged(Configuration newNamespaceConfig, String namespaceID) {
        boolean changed = true;
        NamespaceInfo nsInfo = this.namespaces.get(namespaceID);
        if (nsInfo != null && nsInfo.getConfiguration() != null) {
            changed = nsInfo.getConfiguration().isChanged(newNamespaceConfig);
        }
        return changed;
    }
}

