/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.common.config.AdvancedProperties;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.MissingAttributeException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ConfigurationManager
implements Configuration {
    private final ArrayList listeners = new ArrayList();
    private ICCLConfiguration cclConfig;
    private Document cclConfigDoc;
    private Element configuration;
    private final String configurationPath;

    public ConfigurationManager(ICCLConfiguration theConfiguration, String theConfigurationPath) throws LocalizableException {
        this(theConfiguration, null, theConfigurationPath);
    }

    private ConfigurationManager(ICCLConfiguration theConfiguration, Document theConfigurationDocument, String theConfigurationPath) throws LocalizableException {
        this.configurationPath = theConfigurationPath;
        this.cclConfig = theConfiguration;
        this.cclConfigDoc = theConfigurationDocument;
        this.configuration = this.getConfigElement(theConfiguration, theConfigurationPath);
    }

    @Override
    public void addListener(ConfigurationListener theListener) {
        this.listeners.add(theListener);
    }

    @Override
    public String export() {
        return this.configuration.asXML();
    }

    @Override
    public String getAbsolutePath(String thePath) {
        return this.cclConfig.resolveEffectivePath(thePath);
    }

    @Override
    public Configuration[] getConfiguration(String theXPath) {
        Configuration[] retval = null;
        List nodeList = DocumentHelper.selectNodes((String)theXPath, (Node)this.configuration);
        if (nodeList != null && !nodeList.isEmpty()) {
            retval = new Configuration[nodeList.size()];
            for (int i = 0; i < nodeList.size(); ++i) {
                retval[i] = this.createConfiguration((Node)nodeList.get(i));
            }
        }
        return retval;
    }

    @Override
    public String getMandatoryValue(String theXPath) throws LocalizableException {
        String retval = this.getOptionalValue(theXPath, null);
        if (retval == null) {
            throw new MissingAttributeException(theXPath, "");
        }
        return retval;
    }

    @Override
    public String[] getMandatoryValues(String theXPath) throws LocalizableException {
        String[] retval = this.getOptionalValues(theXPath, null);
        if (retval == null) {
            throw new MissingAttributeException(theXPath, "");
        }
        return retval;
    }

    @Override
    public String getOptionalValue(String theXPath, String theDefaultValue) {
        String value = DocumentHelper.valueOf((String)theXPath, (Node)this.configuration);
        if (value == null) {
            return theDefaultValue;
        }
        return value;
    }

    @Override
    public String[] getOptionalValues(String theXPath, String[] theDefaultValue) {
        List nodes = DocumentHelper.selectNodes((String)theXPath, (Node)this.configuration);
        if (nodes.size() > 0) {
            String[] retval = new String[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                retval[i] = node != null ? node.getStringValue() : null;
            }
            return retval;
        }
        return theDefaultValue;
    }

    @Override
    public Configuration getRootConfiguration() throws LocalizableException {
        return new ConfigurationManager(this.cclConfig, this.cclConfigDoc, null);
    }

    @Override
    public Configuration getSingleConfiguration(String theXPath) {
        return this.createConfiguration(DocumentHelper.selectSingleNode((String)theXPath, (Node)this.configuration));
    }

    public void reconfigure(ICCLConfiguration theNewConfiguration) throws LocalizableException {
        this.cclConfig = theNewConfiguration;
        this.cclConfigDoc = null;
        Element oldConfig = this.configuration.createCopy();
        this.configuration = this.getConfigElement(theNewConfiguration, this.configurationPath);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConfigurationListener listener = (ConfigurationListener)this.listeners.get(i);
            if (listener == null) continue;
            String[] valuePath = listener.getParameterPath();
            boolean hasChanged = false;
            for (int j = 0; j < valuePath.length && !hasChanged; ++j) {
                hasChanged = DocumentHelper.isConfigurationDifferent((List)DocumentHelper.selectNodes((String)valuePath[j], (Node)oldConfig), (List)DocumentHelper.selectNodes((String)valuePath[j], (Node)this.configuration));
            }
            if (!hasChanged) continue;
            listener.configurationChanged(this);
        }
    }

    @Override
    public void removeListener(ConfigurationListener theListener) {
        this.listeners.remove(theListener);
    }

    private Configuration createConfiguration(Node theNode) {
        ConfigurationManager retval = null;
        if (theNode != null) {
            try {
                String configPath = new String();
                if (this.configurationPath != null) {
                    configPath = this.configurationPath + "/";
                }
                configPath = configPath + theNode.getUniquePath(this.configuration);
                retval = new ConfigurationManager(this.cclConfig, this.cclConfigDoc, configPath);
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
        return retval;
    }

    private Document getCCLConfigDocument(ICCLConfiguration theCclConfig) throws LocalizableException {
        try {
            String value = theCclConfig.serialize();
            SAXReader reader = new SAXReader();
            return reader.read((Reader)new StringReader(value));
        }
        catch (CCLConfigurationException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (Throwable)e);
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (Throwable)e);
        }
    }

    private Element getConfigElement(ICCLConfiguration theCclConfig, String theXPath) throws LocalizableException {
        Element itemElement = null;
        Element retval = null;
        if (this.cclConfigDoc == null) {
            this.cclConfigDoc = this.getCCLConfigDocument(theCclConfig);
        }
        if (this.cclConfigDoc.getRootElement() != null) {
            itemElement = (Element)DocumentHelper.selectSingleNode((String)"/*[local-name()='queryResult']/*[local-name()='item']", (Node)this.cclConfigDoc.getRootElement());
        }
        if (theXPath != null) {
            Element element = (Element)DocumentHelper.selectSingleNode((String)theXPath, itemElement);
            if (element != null) {
                retval = element.createCopy();
            }
        } else {
            retval = itemElement.createCopy();
        }
        return retval;
    }

    public AdvancedProperties getAdvancedProperties() {
        return new AdvancedProperties(this);
    }

    @Override
    public boolean isChanged(Configuration theConfiguration) {
        boolean isChanged = true;
        try {
            Document doc1 = DocumentHelper.parseText((String)this.export());
            Document doc2 = DocumentHelper.parseText((String)theConfiguration.export());
            isChanged = DocumentHelper.isConfigurationDifferent((Node)doc1, (Node)doc2);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        return isChanged;
    }
}

