/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.exception.ClassLoadErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.RequestResponseLogger;
import com.ibm.cognos.camaaa.internal.common.logging.RequestResponseLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.soap.CMSoapFault;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import java.lang.reflect.Method;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class CMAccessor
implements ICMAccessor {
    private static final String LOG_CATEGORY = "Trace.CAM.AAA.TRQ.CM";
    private static final String SOAP_BODY_TAG = "SOAP-ENV:Body";
    private static final String CREDENTIALS_PROP = "credentials";
    private static final String MOD_TIME_PROP = "modificationTime";
    private static final String SEARCH_TAG = "search";
    private static final String XSD_NS_PREFIX = "xsd";
    private static final String XSI_TYPE_ATTRIBUTE = "xsi:type";
    private static final String CLASS_NAME = CMAccessor.class.toString();
    private static ICMAccessor servlet;
    private static final String ITEM = "item";
    private Object camConnectorInstance;
    private Class<?> camConnectorClass;
    private Method executeRequestMethod;
    private Exception error;
    private final RequestResponseLogger logger;

    public CMAccessor() {
        String camConnectorClassName = "com.cognos.cm.api.CAMConnector";
        String errorMessage = "com.cognos.cm.api.CAMConnector, the related classes, and fields";
        try {
            this.camConnectorClass = Class.forName("com.cognos.cm.api.CAMConnector");
            this.camConnectorInstance = this.camConnectorClass.getField("INSTANCE").get(null);
            String methodName = "executeRequest";
            this.executeRequestMethod = this.camConnectorClass.getMethod("executeRequest", byte[].class, String.class, Set.class);
        }
        catch (Exception e) {
            this.error = new ClassLoadErrorException("com.cognos.cm.api.CAMConnector, the related classes, and fields", e);
        }
        LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)LOG_CATEGORY, LogTraceIndication.class);
        this.logger = new RequestResponseLoggerImpl(ipfLogger);
    }

    public static Element createCMRequest(Element soapBody, SoapEnvelope env) throws DocumentException {
        String envString = env.toXML();
        Document doc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)envString);
        Element soapEnv = doc.getRootElement();
        Element oldSoapBody = soapEnv.element("Body");
        if (oldSoapBody != null) {
            oldSoapBody.detach();
        }
        soapEnv.add(soapBody);
        return soapEnv;
    }

    public static Element createRequestBodyForTC(String[] credentialPaths) {
        Element soapBodyElement = CMAccessor.createSoapBodyElement();
        Element query = soapBodyElement.addElement("bus:query");
        Element requests = query.addElement("requests");
        for (int i = 0; i < credentialPaths.length; ++i) {
            Element item = requests.addElement(ITEM);
            Element search = item.addElement(SEARCH_TAG);
            Element properties = item.addElement("properties");
            Element itemCredProp = properties.addElement(ITEM);
            itemCredProp.addText(CREDENTIALS_PROP);
            Element itemModTimeProp = properties.addElement(ITEM);
            itemModTimeProp.addText(MOD_TIME_PROP);
            search.setText(credentialPaths[i]);
        }
        return soapBodyElement;
    }

    public static Element createRequestBodyForUpdateTC(String camid, String trustedCredentials) {
        Element soapBodyElement = CMAccessor.createSoapBodyElement();
        soapBodyElement.addNamespace(XSD_NS_PREFIX, "http://www.w3.org/2001/XMLSchema");
        Element addElement = soapBodyElement.addElement("bus:add");
        Element searchElement = addElement.addElement(SEARCH_TAG);
        searchElement.setText(camid);
        Element objectsElement = addElement.addElement("objects");
        objectsElement.addAttribute(XSI_TYPE_ATTRIBUTE, "SOAP-ENC:Array");
        objectsElement.addAttribute("SOAP-ENC:arrayType", "bus:baseClass[1]");
        Element itemElement = objectsElement.addElement(ITEM);
        itemElement.addAttribute(XSI_TYPE_ATTRIBUTE, "bus:credential");
        Element credentialsElement = itemElement.addElement(CREDENTIALS_PROP);
        credentialsElement.addAttribute(XSI_TYPE_ATTRIBUTE, "SOAP-ENC:anyTypeProp");
        Element valueElement = credentialsElement.addElement("value");
        valueElement.addAttribute(XSI_TYPE_ATTRIBUTE, "xsd:string");
        valueElement.addAttribute("xml:space", "preserve");
        valueElement.setText(trustedCredentials);
        Element optionsElement = addElement.addElement("options");
        optionsElement.addAttribute(XSI_TYPE_ATTRIBUTE, "bus:addOptions");
        Element updateActionsElement = optionsElement.addElement("updateAction");
        updateActionsElement.addAttribute(XSI_TYPE_ATTRIBUTE, "bus:updateActionEnum");
        updateActionsElement.setText("update");
        return soapBodyElement;
    }

    protected static Element createSoapBodyElement() {
        Element soapBodyElement = DocumentHelper.createElement((String)SOAP_BODY_TAG);
        soapBodyElement.addNamespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        soapBodyElement.addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        soapBodyElement.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        soapBodyElement.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        return soapBodyElement;
    }

    public static ICMAccessor getInstance() throws LocalizableException {
        if (servlet == null) {
            servlet = new CMAccessor();
        }
        return servlet;
    }

    public static void setInstance(ICMAccessor aServlet) {
        servlet = aServlet;
    }

    void checkForExceptions(String response) throws SoapFaultException {
        try {
            Document doc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)response);
            Element faultElement = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((String)"//*[local-name()='Body']/*[local-name()='Fault']", (Node)doc.getRootElement());
            if (faultElement == null) {
                return;
            }
            throw new SoapFaultException((SoapFault)new CMSoapFault(faultElement));
        }
        catch (DocumentException e) {
            throw new InternalErrorException(CMAccessor.class.toString(), (Exception)((Object)e));
        }
    }

    @Override
    public String invoke(String theRequest) throws SoapFaultException {
        return this.executeRequest(theRequest, null, null);
    }

    @Override
    public String invoke(String theRequest, String tenantID, Set<String> readTenantIds) throws SoapFaultException {
        return this.executeRequest(theRequest, tenantID, readTenantIds);
    }

    private String executeRequest(String theRequest, String tenantID, Set<String> readTenantIds) throws SoapFaultException {
        String response;
        this.logger.logRequest(null, ComponentImpl.getInstance(), Logger.LEVEL4, theRequest);
        String utf8 = "UTF8";
        try {
            if (this.error != null) {
                throw this.error;
            }
            Object[] args = new Object[]{theRequest.getBytes("UTF8"), tenantID, readTenantIds};
            response = new String((byte[])this.executeRequestMethod.invoke(this.camConnectorInstance, args), "UTF8");
        }
        catch (Exception e) {
            throw new FunctionCallFailedException(CLASS_NAME, "com.cognos.cm.api.CAMConnector.executeRequest()", e);
        }
        this.logger.logResponse(null, ComponentImpl.getInstance(), Logger.LEVEL4, response);
        this.checkForExceptions(response);
        return response;
    }
}

