/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.ibm.cognos.camaaa.internal.admin.cognosns.CognosOMBridgeSoapAction;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.soap.CMSoapFault;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceCommunicator;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceHttpCommunicator;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class CMAccessorHTTP
implements ICMAccessor {
    private static final XPath BODY_FAULT_XPATH = DocumentHelper.createXPath((String)"//*[local-name()='Body']/*[local-name()='Fault']");
    private static final XPath CM_URL_XPATH = DocumentHelper.createXPath((String)"//*[local-name()='getActiveContentManagerResponse']/result/text()");
    private static final String TRUSTED_SERVICE_ID = "CM";
    private static final String DEFAULT_SERVICE_ID = "CAMAAService";
    private final CAMAAServiceCommunicator comm;
    private final String serviceId;
    private final String trustedServiceId;

    public CMAccessorHTTP(CAMAAServiceCommunicator theComm) {
        this.comm = theComm;
        this.serviceId = DEFAULT_SERVICE_ID;
        this.trustedServiceId = TRUSTED_SERVICE_ID;
    }

    public CMAccessorHTTP(URL theURL) throws LocalizableException {
        this(theURL, DEFAULT_SERVICE_ID);
    }

    public CMAccessorHTTP(URL theURL, String theServiceId) throws LocalizableException {
        this.comm = new CAMAAServiceHttpCommunicator(theURL, 1);
        this.serviceId = theServiceId;
        this.trustedServiceId = this.serviceId.equals(DEFAULT_SERVICE_ID) ? TRUSTED_SERVICE_ID : theServiceId;
    }

    public static URL getActiveCM(ICMAccessor accessor) throws LocalizableException {
        String getActiveCMRequest = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Header><bus:biBusHeader/></SOAP-ENV:Header><SOAP-ENV:Body><cm:getActiveContentManager xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"/></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        String getActiveCMResponse = accessor.invoke(CMAccessorHTTP.signRequest("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Header><bus:biBusHeader/></SOAP-ENV:Header><SOAP-ENV:Body><cm:getActiveContentManager xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"/></SOAP-ENV:Body></SOAP-ENV:Envelope>", DEFAULT_SERVICE_ID, TRUSTED_SERVICE_ID));
        if (getActiveCMResponse != null) {
            try {
                Document doc = DocumentHelper.parseText((String)getActiveCMResponse);
                String cmURLStr = DocumentHelper.valueOf((XPath)CM_URL_XPATH, (Node)doc.getRootElement());
                return new URL(cmURLStr);
            }
            catch (DocumentException e) {
                throw new InternalErrorException(CMAccessorHTTP.class.toString(), (Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new InternalErrorException(CMAccessorHTTP.class.toString(), e);
            }
        }
        throw new InternalErrorException(CMAccessorHTTP.class.toString());
    }

    private static String signRequest(String request, String serviceId, String trustedServiceId) throws LocalizableException {
        try {
            CAMFactory camf = new CAMFactory();
            String theServiceId = "<initializeDocument><serviceID>" + serviceId + "</serviceID></initializeDocument>";
            camf.initialize(theServiceId.getBytes());
            TrustedRequestSession session = camf.createTrustedSession();
            byte[] trustedReqBytes = session.setMessageTrust(trustedServiceId, request.getBytes());
            String trustedRequestStr = new String(trustedReqBytes, "UTF8");
            return trustedRequestStr;
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(CMAccessorHTTP.class.toString(), (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(CMAccessorHTTP.class.toString(), e);
        }
    }

    private void checkForExceptions(Document doc) throws SoapFaultException {
        Element faultElement = DocumentHelper.selectSingleElement((XPath)BODY_FAULT_XPATH, (Node)doc.getRootElement());
        if (faultElement == null) {
            return;
        }
        throw new SoapFaultException((SoapFault)new CMSoapFault(faultElement));
    }

    @Override
    public String invoke(String theRequest) throws SoapFaultException {
        return this.invoke(theRequest, null, null);
    }

    @Override
    public String invoke(String theRequest, String tenantID, Set<String> readTenantIds) throws SoapFaultException {
        Document doc = this.invokeDoc(theRequest);
        if (doc != null) {
            return doc.asXML();
        }
        return null;
    }

    public Document invokeDoc(String theRequest) throws SoapFaultException {
        Document doc;
        try {
            doc = this.comm.processSoapRequest(CMAccessorHTTP.signRequest(theRequest, this.serviceId, this.trustedServiceId), CognosOMBridgeSoapAction.getLatestCMSoapAction());
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        if (doc != null) {
            this.checkForExceptions(doc);
            return doc;
        }
        return null;
    }
}

