/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.auth.exception.AuthenticationExceptionUtils;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactory;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class HandlerBindingImpl
implements HandlerBinding {
    private static Map requestNameToTypeMapping = new HashMap();
    private final HandlerFactory handlerFactory;
    private final Vector actions = new Vector();

    HandlerBindingImpl(HandlerFactory theHandlerFactory) {
        this.handlerFactory = theHandlerFactory;
    }

    private static void handleFault(MessageContext messageContext, Handler handler, SoapFaultException e) {
        HandlerBindingImpl.setFaultEntry(messageContext, e);
        try {
            handler.handleFault(messageContext);
        }
        catch (SoapFaultException soapFaultException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void setFaultEntry(MessageContext messageContext, SoapFaultException e) {
        SoapEnvelopeResponse soapEnvelopeResp = (SoapEnvelopeResponse)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        if (soapEnvelopeResp.getBody().getBodyEntry().getType() != 19) {
            SoapFaultException theException = AuthenticationExceptionUtils.convertToAuthenticationFaultIfRequired(e, messageContext);
            soapEnvelopeResp.setFaultEntry((SoapFault)theException, messageContext);
        }
    }

    void addActionHandler(String request, Handler h) throws LocalizableException {
        int requestType = this.getRequestType(request);
        if (this.actions.size() <= requestType) {
            this.actions.setSize(requestType + 1);
        }
        this.actions.set(requestType, h);
    }

    public Handler getHandler(int request) {
        if (request < 0 || request >= this.actions.size()) {
            return null;
        }
        return (Handler)this.actions.get(request);
    }

    public Handler getHandler(String chain) {
        try {
            return this.handlerFactory.getHandlerByName(chain);
        }
        catch (LocalizableException e) {
            return null;
        }
    }

    static String getRequestName(int theRequestType) throws LocalizableException {
        for (Map.Entry entry : requestNameToTypeMapping.entrySet()) {
            if ((Integer)entry.getValue() != theRequestType) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private int getRequestType(String request) throws LocalizableException {
        Integer requestType = (Integer)requestNameToTypeMapping.get(request);
        if (requestType == null) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_UNEXPECTED_REQUEST", (Object[])new String[]{request}));
        }
        return requestType;
    }

    public void handleRequest(MessageContext messageContext, Handler handler) {
        try {
            this.handleRequestRequired(messageContext, handler);
        }
        catch (SoapFaultException soapFaultException) {
            // empty catch block
        }
    }

    public void handleRequestRequired(MessageContext messageContext, Handler handler) throws SoapFaultException {
        SoapFaultException exception = null;
        try {
            if (!handler.handleMessage(messageContext)) {
                messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound", (Object)Boolean.TRUE);
                handler.handleMessage(messageContext);
            }
        }
        catch (SoapFaultException e) {
            exception = e;
            HandlerBindingImpl.handleFault(messageContext, handler, e);
        }
        catch (RuntimeException e) {
            exception = new InternalErrorException(HandlerBindingImpl.class.toString(), e);
            HandlerBindingImpl.setFaultEntry(messageContext, exception);
        }
        handler.close(messageContext);
        if (exception != null) {
            throw exception;
        }
    }

    static {
        requestNameToTypeMapping.put("query", new Integer(1));
        requestNameToTypeMapping.put("logon", new Integer(2));
        requestNameToTypeMapping.put("logonTC", new Integer(22));
        requestNameToTypeMapping.put("validate", new Integer(3));
        requestNameToTypeMapping.put("logoff", new Integer(4));
        requestNameToTypeMapping.put("generateTC", new Integer(5));
        requestNameToTypeMapping.put("retrieveCredential", new Integer(6));
        requestNameToTypeMapping.put("selectRoles", new Integer(7));
        requestNameToTypeMapping.put("havePassportsExpired", new Integer(8));
        requestNameToTypeMapping.put("getIdentity", new Integer(9));
        requestNameToTypeMapping.put("clonePassport", new Integer(20));
        requestNameToTypeMapping.put("renewTC", new Integer(24));
        requestNameToTypeMapping.put("terminateSessions", new Integer(26));
        requestNameToTypeMapping.put("selectTenants", new Integer(28));
        requestNameToTypeMapping.put("validateWithResponse", new Integer(30));
    }
}

