/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.HandlerChainConfigException;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidCfgAttributeValueException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.MissingAttributeException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.exception.UnexpectedElementException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactory;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerWrapper;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.handler.UniqueHashCode;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;

public abstract class HandlerChain
extends UniqueHashCode
implements Handler {
    public static final QName ID = QName.get((String)"id");
    public static final QName NAME = QName.get((String)"name");
    private static final String ITERATOR_KEY = "Iterator";
    private List handlers = null;
    private String name = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(MessageContext theContext) {
        ListIterator it = (ListIterator)theContext.getLocal(ITERATOR_KEY);
        try {
            RuntimeException exception = null;
            for (int i = it.previousIndex(); i >= 0; --i) {
                try {
                    Handler handler = (Handler)this.handlers.get(i);
                    handler.close(theContext);
                    continue;
                }
                catch (RuntimeException rte) {
                    if (exception != null) continue;
                    exception = rte;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            theContext.removeLocal(ITERATOR_KEY);
        }
    }

    public void destroy() {
        if (this.handlers != null) {
            this.handlers.clear();
            this.handlers = null;
        }
    }

    protected abstract QName getElementQName();

    public String getName() {
        return this.name;
    }

    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        boolean retval = true;
        ListIterator it = (ListIterator)theContext.getLocal(ITERATOR_KEY);
        for (int i = it.previousIndex(); i >= 0 && retval; --i) {
            Handler handler = (Handler)this.handlers.get(i);
            retval = handler.handleFault(theContext);
        }
        return retval;
    }

    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        ListIterator it = null;
        boolean retval = true;
        if (!((Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound")).booleanValue()) {
            it = this.handlers.listIterator();
            theContext.putLocal(ITERATOR_KEY, (Object)it);
            retval = this.invokeHandlersForward(it, theContext);
        } else {
            it = (ListIterator)theContext.getLocal(ITERATOR_KEY);
            retval = this.invokeHandlersBackward(it, theContext);
        }
        return retval;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.handlers = null;
        this.name = null;
        String handlerConfiguration = (String)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfiguration");
        Element root = (Element)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfigurationElement");
        try {
            Document doc = DocumentHelper.parseText((String)handlerConfiguration);
            if (doc != null) {
                root = doc.getRootElement();
            }
        }
        catch (DocumentException e) {
            throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
        }
        if (root != null && root.getNodeType() == 1) {
            this.processHandlerChain(theConfig, handlerConfiguration, root);
        }
        if (this.handlers == null) {
            LocalizableException e = new LocalizableException((LocalizableMessage)new Message("AAA_CFG_HANDLER_CHAIN_EMPTY"));
            throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
        }
    }

    protected boolean invokeHandlersBackward(ListIterator theIterator, MessageContext theContext) throws SoapFaultException {
        boolean retval = true;
        if (theIterator != null) {
            for (int i = theIterator.previousIndex(); i >= 0 && retval; --i) {
                Handler handler = (Handler)this.handlers.get(i);
                retval = handler.handleMessage(theContext);
            }
        } else {
            retval = false;
        }
        return retval;
    }

    protected boolean invokeHandlersForward(ListIterator theIterator, MessageContext theContext) throws SoapFaultException {
        boolean retval = true;
        while (theIterator.hasNext()) {
            Handler handler = (Handler)theIterator.next();
            boolean continueProcessing = handler.handleMessage(theContext);
            if (continueProcessing) continue;
            retval = false;
            break;
        }
        return retval;
    }

    private void processHandlerChain(HandlerInfo theConfig, String handlerConfiguration, Element root) throws LocalizableException {
        if (root.getQName().equals((Object)this.getElementQName())) {
            this.name = root.attributeValue(NAME);
            if (this.name == null) {
                MissingAttributeException e = new MissingAttributeException(NAME.getQualifiedName(), this.getElementQName().getQualifiedName());
                throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
            }
            HashSet<String> idUsedInThisChain = new HashSet<String>();
            List handlerList = root.elements();
            if (handlerList.size() > 0) {
                HandlerFactory handlerFactory = (HandlerFactory)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerFactory");
                this.handlers = new ArrayList(handlerList.size());
                for (int i = 0; i < handlerList.size(); ++i) {
                    Element e = (Element)handlerList.get(i);
                    Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
                    this.setChainUniqueID(idUsedInThisChain, e, i);
                    this.handlers.add(handlerFactory.createHandler(config, e));
                }
            }
        } else {
            UnexpectedElementException e = new UnexpectedElementException(root.getQName().getQualifiedName(), this.getElementQName().getQualifiedName());
            throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
        }
    }

    private void setChainUniqueID(Set<String> theIdUsedInThisChain, Element theConfigElement, int theIndexInChain) throws InvalidCfgAttributeValueException {
        Attribute idAttr;
        String chainName = theConfigElement.attributeValue("name");
        String handlerName = theConfigElement.attributeValue("handler");
        StringWriter sw = new StringWriter();
        if (handlerName == null) {
            if (chainName == null) {
                throw new InvalidCfgAttributeValueException(HandlerWrapper.class.getName(), chainName, "name");
            }
            sw.append(chainName);
        } else {
            int dot = handlerName.lastIndexOf(46);
            if (dot > 0 && dot < handlerName.length()) {
                sw.append(handlerName.substring(dot + 1));
            } else {
                sw.append(handlerName);
            }
        }
        if (theIdUsedInThisChain.contains(sw.toString())) {
            sw.append('-');
            sw.append(Integer.toString(theIndexInChain));
        }
        if ((idAttr = theConfigElement.attribute(ID)) != null) {
            theConfigElement.remove(idAttr);
        }
        theConfigElement.addAttribute(ID, sw.toString());
        theIdUsedInThisChain.add(sw.toString());
    }
}

