/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.common.HandlerInfoImpl;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.BadXmlFileException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerDispatcher;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactoryImpl;
import com.ibm.cognos.camaaa.internal.common.handler.LogonTester;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;

public class HandlerConfigTester {
    public static final String TEST_FEEDBACK = "test.feedback";
    public static final String TEST_NAMESPACE = "test.namespace";
    private static final String TEST_HANDLER_CONFIG_XSLT = "testHandlerConfig.xslt";
    private static final String HANDLER_CONFIG = "handlerConfig.xml";

    public void test(Configuration config, Feedback feedback) throws LocalizableException {
        this.test(config, feedback, null);
    }

    public void test(Configuration config, Feedback feedback, String namespace) throws LocalizableException {
        this.test(config, feedback, namespace, HANDLER_CONFIG);
    }

    public void test(Configuration config, Feedback feedback, String namespace, String handlerConfigFile) throws LocalizableException {
        HandlerInfoImpl additionalHandlerInfo = new HandlerInfoImpl();
        additionalHandlerInfo.put(TEST_NAMESPACE, namespace);
        additionalHandlerInfo.put(TEST_FEEDBACK, feedback);
        HandlerFactoryImpl handlerFactory = new HandlerFactoryImpl(null, null, additionalHandlerInfo);
        HandlerDispatcher binding = new HandlerDispatcher(handlerFactory);
        try {
            String testHandlerConfig = this.createTestHandlerConfig(HandlerDispatcher.getHandlerConfiguration(handlerConfigFile), HandlerConfigTester.class.getResourceAsStream(TEST_HANDLER_CONFIG_XSLT));
            ByteArrayInputStream testHandlerConfigStream = new ByteArrayInputStream(testHandlerConfig.getBytes("UTF-8"));
            binding.init(testHandlerConfigStream, config);
        }
        catch (LocalizableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadXmlFileException(TEST_HANDLER_CONFIG_XSLT, e);
        }
        finally {
            binding.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testLogon(ICCLConfiguration cclConfiguration, String credentials, Feedback feedback) throws LocalizableException {
        boolean result = false;
        LogonTester logonTester = new LogonTester(cclConfiguration);
        try {
            String passport = logonTester.attemptLogon(credentials, feedback);
            if (passport == null || passport.isEmpty()) {
                boolean bl = result;
                return bl;
            }
            result = logonTester.getAccountPropertiesAndMembership(passport, feedback);
            result = logonTester.getTenancy(passport, feedback);
        }
        finally {
            logonTester.dispose();
        }
        return result;
    }

    private String createTestHandlerConfig(Element handlerConfig, InputStream stylesheet) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer transformer = factory.newTransformer(new StreamSource(stylesheet));
        DocumentSource source = new DocumentSource((Node)handlerConfig);
        DocumentResult result = new DocumentResult();
        transformer.transform((Source)source, (Result)result);
        Document transformedDoc = result.getDocument();
        return transformedDoc.asXML();
    }

    public static interface Feedback {
        public void showInformation(String var1);

        public void showError(String var1);

        public void showWarning(String var1);
    }
}

