/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.BadXmlFileException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.ActionHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBindingImpl;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactory;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HandlerDispatcher
implements HandlerBinding {
    static final String HANDLER_CONFIGURATION_ELEMENT = "handler-configuration";
    private static final String REQUEST_ATTRIBUTE = "request";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private static final String ACTIONS_ELEMENT = "actions";
    private final HandlerFactory handlerFactory;
    private final HandlerBindingImpl binding;

    public HandlerDispatcher(HandlerFactory theFactory) {
        this.handlerFactory = theFactory;
        this.binding = new HandlerBindingImpl(theFactory);
    }

    public static Element getHandlerConfiguration(String file) throws LocalizableException {
        Element configDoc;
        try {
            InputStream is = HandlerDispatcher.class.getResourceAsStream(file);
            configDoc = HandlerDispatcher.parseConfiguration(is);
        }
        catch (DocumentException e) {
            throw new BadXmlFileException(file, (Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            throw new BadXmlFileException(file, e);
        }
        catch (SAXException e) {
            throw new BadXmlFileException(file, e);
        }
        return configDoc;
    }

    static void loadActions(Configuration config, Element configDoc, HandlerFactory handlerFactory, HandlerBindingImpl binding) throws LocalizableException {
        Element actionsElement = configDoc.element(ACTIONS_ELEMENT);
        if (actionsElement != null) {
            Iterator it = actionsElement.elementIterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                Attribute requestAttribute = e.attribute(REQUEST_ATTRIBUTE);
                if (requestAttribute == null || requestAttribute.getText().length() <= 0) {
                    throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_MISSING_ATTRIBUTE", (Object[])new String[]{REQUEST_ATTRIBUTE, e.getName()}));
                }
                Attribute handlerAttribute = e.attribute(HANDLER_ATTRIBUTE);
                if (handlerAttribute == null || handlerAttribute.getText().length() <= 0) {
                    throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_MISSING_ATTRIBUTE", (Object[])new String[]{HANDLER_ATTRIBUTE, e.getName()}));
                }
                String request = requestAttribute.getText();
                String handlerName = handlerAttribute.getText();
                ActionHandler h = new ActionHandler(request, handlerFactory.getHandlerByName(handlerName));
                binding.addActionHandler(request, h);
            }
        }
    }

    private static Element parseConfiguration(InputStream in) throws DocumentException, ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setXIncludeAware(true);
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        SAXReader saxReader = new SAXReader(xmlReader);
        Document doc = saxReader.read(in);
        Element configDoc = doc.getRootElement();
        return configDoc;
    }

    public void destroy() {
        this.handlerFactory.destroy();
    }

    public Handler getHandler(int request) {
        return this.binding.getHandler(request);
    }

    public Handler getHandler(String chain) {
        return this.binding.getHandler(chain);
    }

    public void handleRequest(MessageContext messageContext, Handler theHandler) {
        if (!messageContext.containsKey((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding")) {
            messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding", (Object)this);
        }
        this.binding.handleRequest(messageContext, theHandler);
    }

    public void handleRequestRequired(MessageContext messageContext, Handler theHandler) throws SoapFaultException {
        if (!messageContext.containsKey((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding")) {
            messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding", (Object)this);
        }
        this.binding.handleRequestRequired(messageContext, theHandler);
    }

    void init(InputStream handlerConfig, Configuration config) throws LocalizableException {
        Element configDoc;
        try {
            configDoc = HandlerDispatcher.parseConfiguration(handlerConfig);
        }
        catch (DocumentException e) {
            throw new BadXmlFileException(handlerConfig.toString(), (Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            throw new BadXmlFileException(handlerConfig.toString(), e);
        }
        catch (SAXException e) {
            throw new BadXmlFileException(handlerConfig.toString(), e);
        }
        this.loadHandlerChains(config, configDoc);
        HandlerDispatcher.loadActions(config, configDoc, this.handlerFactory, this.binding);
    }

    public void init(String file, Configuration config) throws LocalizableException {
        Element configDoc = HandlerDispatcher.getHandlerConfiguration(file);
        if (configDoc.getName() != HANDLER_CONFIGURATION_ELEMENT) {
            throw new BadXmlFileException(file, null);
        }
        this.loadHandlerChains(config, configDoc);
        HandlerDispatcher.loadActions(config, configDoc, this.handlerFactory, this.binding);
    }

    private void loadHandlerChains(Configuration config, Element configDoc) throws LocalizableException {
        this.handlerFactory.init(config, configDoc.asXML());
    }
}

