/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.ibm.cognos.camaaa.internal.admin.handler.AdminHandler;
import com.ibm.cognos.camaaa.internal.admin.handler.AdminHandlerChain;
import com.ibm.cognos.camaaa.internal.auth.handler.AuthHandler;
import com.ibm.cognos.camaaa.internal.auth.handler.AuthHandlerChain;
import com.ibm.cognos.camaaa.internal.common.HandlerInfoImpl;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.ClassLoadErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SelfReferencingHandlerChainException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactory;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.IsolatedHandler;
import com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class HandlerFactoryImpl
implements HandlerFactory {
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String HANDLER_ATTRIBUTE = "handler";
    private static final String HANDLER = "handler";
    private static final String HANDLER_CHAINS_ELEMENT = "handler-chains";
    private static final String CLASS_LOADER_ATTRIBUTE = "class-loader";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String INIT_DOCUMENT = "<initializeDocument><serviceID>CAMAAA</serviceID></initializeDocument>";
    private static final String CLASS_NAME = HandlerFactoryImpl.class.toString();
    private static final QName HANDLER_ELEMENT = QName.get((String)"handler", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName HANDLER_INFO = QName.get((String)"handler-info", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName AUTH_HANDLER_CHAIN_ELEMENT = QName.get((String)"auth-handler-chain", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName AUTH_HANDLER_REF_ELEMENT = QName.get((String)"auth-handler-ref", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName AUTH_HANDLER_ELEMENT = QName.get((String)"auth-handler", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName ADMIN_HANDLER_CHAIN_ELEMENT = QName.get((String)"admin-handler-chain", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName ADMIN_HANDLER_REF_ELEMENT = QName.get((String)"admin-handler-ref", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName ADMIN_HANDLER_ELEMENT = QName.get((String)"admin-handler", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private final Set infiniteRecursionChecker;
    private Map namedHandlers = null;
    private Vector anonymousHandlers = null;
    private final Map builtinHandlerTypes;
    private final Map builtinHandlerInfo;
    private final HandlerInfoImpl presistantHandlerInfo = new HandlerInfoImpl();
    private final NamespaceManager namespaceManager;
    private DyeTraceManagerMBean dyeTraceManager;
    private final CAMFactory camFactory;
    private HandlerInfo additionalHandlerInfo;

    public HandlerFactoryImpl(NamespaceManager theNamespaceManager) {
        this.infiniteRecursionChecker = new HashSet();
        this.builtinHandlerTypes = new HashMap();
        this.builtinHandlerTypes.put(AUTH_HANDLER_REF_ELEMENT, new BuiltinHandlerTypeEntry(AuthHandler.class, false));
        this.builtinHandlerTypes.put(ADMIN_HANDLER_REF_ELEMENT, new BuiltinHandlerTypeEntry(AdminHandler.class, false));
        this.builtinHandlerTypes.put(AUTH_HANDLER_ELEMENT, new BuiltinHandlerTypeEntry(AuthHandler.class, false));
        this.builtinHandlerTypes.put(ADMIN_HANDLER_ELEMENT, new BuiltinHandlerTypeEntry(AdminHandler.class, false));
        this.builtinHandlerTypes.put(AUTH_HANDLER_CHAIN_ELEMENT, new BuiltinHandlerTypeEntry(AuthHandlerChain.class, true));
        this.builtinHandlerTypes.put(ADMIN_HANDLER_CHAIN_ELEMENT, new BuiltinHandlerTypeEntry(AdminHandlerChain.class, true));
        this.builtinHandlerInfo = new HashMap();
        this.namespaceManager = theNamespaceManager;
        this.dyeTraceManager = null;
        this.additionalHandlerInfo = null;
        this.camFactory = new CAMFactory();
    }

    public HandlerFactoryImpl(NamespaceManager theNamespaceManager, DyeTraceManagerMBean theDyeTraceManager) {
        this(theNamespaceManager);
        this.dyeTraceManager = theDyeTraceManager;
    }

    public HandlerFactoryImpl(NamespaceManager theNamespaceManager, DyeTraceManagerMBean theDyeTraceManager, HandlerInfo theAdditionalHandlerInfo) {
        this(theNamespaceManager, theDyeTraceManager);
        this.additionalHandlerInfo = theAdditionalHandlerInfo;
    }

    private static String getRequiredAttribute(Element e, String attribute) throws LocalizableException {
        String value = e.attributeValue(attribute);
        if (value == null || value.length() <= 0) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_MISSING_ATTRIBUTE", (Object[])new String[]{attribute, e.getQualifiedName()}));
        }
        return value;
    }

    private static Element parseConfiguration(String configuration) throws LocalizableException {
        try {
            Document doc = DocumentHelper.parseText((String)configuration);
            return doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_HANDLER_CHAIN_CONFIG_ERROR", (Object[])new String[]{configuration}), (Throwable)e);
        }
    }

    private void addBuiltinHandlerInfoEntries(HandlerInfo theHandlerInfo, Configuration configuration) throws LocalizableException {
        if (this.builtinHandlerInfo.isEmpty()) {
            return;
        }
        for (String name : this.builtinHandlerInfo.keySet()) {
            Class aClass = (Class)this.builtinHandlerInfo.get(name);
            try {
                Constructor constructor = aClass.getConstructor(Configuration.class);
                Object instance = constructor.newInstance(configuration);
                theHandlerInfo.put((Object)name, instance);
            }
            catch (Exception e) {
                throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_CLASS_LOAD_ERROR", (Object[])new String[]{aClass.getName()}), (Throwable)e);
            }
        }
    }

    private void addHandlerInfoEntry(Element element) throws LocalizableException {
        QName type = element.getQName();
        if (type.equals((Object)HANDLER_INFO)) {
            String name = HandlerFactoryImpl.getRequiredAttribute(element, NAME_ATTRIBUTE);
            String className = HandlerFactoryImpl.getRequiredAttribute(element, VALUE_ATTRIBUTE);
            try {
                this.builtinHandlerInfo.put(name, Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_CLASS_LOAD_ERROR", (Object[])new String[]{className}), (Throwable)e);
            }
        }
    }

    private void checkInfiniteRecursion(String s) throws LocalizableException {
        if (!this.infiniteRecursionChecker.add(s)) {
            throw new SelfReferencingHandlerChainException(s);
        }
    }

    @Override
    public Handler createHandler(Configuration configuration, Element handlerConfiguration) throws LocalizableException {
        Handler handler = this.createHandler(handlerConfiguration);
        if (handler != null) {
            this.initializeHandler(handler, configuration, handlerConfiguration);
        }
        return handler;
    }

    @Override
    public Handler createHandler(Configuration configuration, String handlerConfiguration) throws LocalizableException {
        Element root = HandlerFactoryImpl.parseConfiguration(handlerConfiguration);
        return this.createHandler(configuration, root);
    }

    private Handler createHandler(Element element) throws LocalizableException {
        QName type = element.getQName();
        Handler handler = null;
        if (this.builtinHandlerTypes.containsKey(type)) {
            BuiltinHandlerTypeEntry typeEntry = (BuiltinHandlerTypeEntry)this.builtinHandlerTypes.get(type);
            String name = null;
            if (typeEntry.hasName()) {
                name = HandlerFactoryImpl.getRequiredAttribute(element, NAME_ATTRIBUTE);
            }
            if (name != null && this.namedHandlers.get(name) != null) {
                throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_HANDLER_ALREADY_EXISTS", (Object[])new String[]{name}));
            }
            handler = typeEntry.createHandler();
            if (name != null) {
                this.namedHandlers.put(name, handler);
            } else {
                this.anonymousHandlers.add(handler);
            }
        } else if (type.equals((Object)HANDLER_ELEMENT)) {
            handler = this.makeNonBuiltinHandler(element);
            this.anonymousHandlers.add(handler);
        } else {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_UNEXPECTED_ELEMENT_SHORT", (Object[])new String[]{type.getName()}));
        }
        return handler;
    }

    private HandlerInfo createHandlerInfo(Configuration configuration, Element handlerConfiguration) throws LocalizableException {
        HandlerInfoImpl theConfig = this.additionalHandlerInfo != null ? new HandlerInfoImpl((Map)this.additionalHandlerInfo) : new HandlerInfoImpl();
        this.addBuiltinHandlerInfoEntries(theConfig, configuration);
        theConfig.put("persistent.HandlerInfo", this.presistantHandlerInfo);
        theConfig.put("com.ibm.cognos.camaaa.internal.common.handler.init.handlerFactory", this);
        theConfig.put("com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfiguration", handlerConfiguration.asXML());
        theConfig.put("com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfigurationElement", handlerConfiguration);
        theConfig.put("com.ibm.cognos.camaaa.internal.common.handler.init.configuration", configuration);
        if (this.namespaceManager != null) {
            theConfig.put("com.ibm.cognos.camaaa.internal.common.NamespaceManager", this.namespaceManager);
        }
        if (this.dyeTraceManager != null) {
            theConfig.put("com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean", this.dyeTraceManager);
        }
        if (this.camFactory != null) {
            theConfig.put("com.cognos.accman.jcam.crypto.CAMFactory", this.camFactory);
        }
        return theConfig;
    }

    @Override
    public void destroy() {
        if (this.namedHandlers != null) {
            for (Object o : this.namedHandlers.values()) {
                ((Handler)o).destroy();
            }
            this.namedHandlers.clear();
            this.namedHandlers = null;
        }
        if (this.anonymousHandlers != null) {
            for (Object o : this.anonymousHandlers) {
                ((Handler)o).destroy();
            }
            this.anonymousHandlers.clear();
            this.anonymousHandlers = null;
        }
    }

    @Override
    public Handler getHandlerByName(String name) throws LocalizableException {
        Handler handler = (Handler)this.namedHandlers.get(name);
        if (handler == null) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_HANDLER_NOT_FOUND", (Object[])new String[]{name}));
        }
        return handler;
    }

    private void getHandlerChains(Configuration configuration, Element rootElement) throws LocalizableException {
        Element e;
        Iterator it;
        Element chainsElement;
        Iterator chainsIt = rootElement.elementIterator(HANDLER_CHAINS_ELEMENT);
        while (chainsIt.hasNext()) {
            chainsElement = (Element)chainsIt.next();
            if (chainsElement == null) continue;
            it = chainsElement.elementIterator(AUTH_HANDLER_CHAIN_ELEMENT);
            while (it.hasNext()) {
                e = (Element)it.next();
                this.createHandler(e);
            }
            it = chainsElement.elementIterator(ADMIN_HANDLER_CHAIN_ELEMENT);
            while (it.hasNext()) {
                e = (Element)it.next();
                this.createHandler(e);
            }
        }
        chainsIt = rootElement.elementIterator(HANDLER_CHAINS_ELEMENT);
        while (chainsIt.hasNext()) {
            Handler h;
            String name;
            chainsElement = (Element)chainsIt.next();
            if (chainsElement == null) continue;
            it = chainsElement.elementIterator(AUTH_HANDLER_CHAIN_ELEMENT);
            while (it.hasNext()) {
                e = (Element)it.next();
                name = HandlerFactoryImpl.getRequiredAttribute(e, NAME_ATTRIBUTE);
                h = (Handler)this.namedHandlers.get(name);
                this.initializeHandler(h, configuration, e);
            }
            it = chainsElement.elementIterator(ADMIN_HANDLER_CHAIN_ELEMENT);
            while (it.hasNext()) {
                e = (Element)it.next();
                name = HandlerFactoryImpl.getRequiredAttribute(e, NAME_ATTRIBUTE);
                h = (Handler)this.namedHandlers.get(name);
                this.initializeHandler(h, configuration, e);
            }
        }
    }

    HandlerBinding getNamespaceBinding(String theNamespaceID) {
        return this.namespaceManager.getNamespaceBinding(theNamespaceID);
    }

    @Override
    public void init(Configuration configuration, String handlerConfiguration) throws LocalizableException {
        this.namedHandlers = new HashMap();
        this.anonymousHandlers = new Vector();
        try {
            this.camFactory.initialize(INIT_DOCUMENT.getBytes());
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(CLASS_NAME, "CAMFactory.initialize", (Exception)((Object)e));
        }
        Element rootElement = HandlerFactoryImpl.parseConfiguration(handlerConfiguration);
        Iterator it = rootElement.elementIterator(HANDLER_INFO);
        while (it.hasNext()) {
            Element e = (Element)it.next();
            this.addHandlerInfoEntry(e);
        }
        this.getHandlerChains(configuration, rootElement);
    }

    private void initializeHandler(Handler handler, Configuration configuration, Element handlerConfiguration) throws LocalizableException {
        HandlerInfo theConfig = this.createHandlerInfo(configuration, handlerConfiguration);
        String name = handlerConfiguration.attributeValue(NAME_ATTRIBUTE);
        if (handler.getClass() == AuthHandler.class || handler.getClass() == AdminHandler.class) {
            handler.init(theConfig);
        } else if (name != null) {
            this.checkInfiniteRecursion(name);
            handler.init(theConfig);
            this.uncheckInfiniteRecursion(name);
        } else {
            handler.init(theConfig);
        }
    }

    private Handler makeNonBuiltinHandler(Element element) throws LocalizableException {
        String handlerClassName = HandlerFactoryImpl.getRequiredAttribute(element, "handler");
        String handlerClassLoader = element.attributeValue(CLASS_LOADER_ATTRIBUTE);
        try {
            if (handlerClassLoader == null) {
                return (Handler)Class.forName(handlerClassName).newInstance();
            }
            ClassLoader cl = (ClassLoader)Class.forName(handlerClassLoader).newInstance();
            Handler subHandler = (Handler)Class.forName(handlerClassLoader, true, cl).newInstance();
            return new IsolatedHandler(subHandler, cl);
        }
        catch (InstantiationException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_CLASS_LOAD_ERROR", (Object[])new String[]{handlerClassName}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_CLASS_LOAD_ERROR", (Object[])new String[]{handlerClassName}), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_CLASS_LOAD_ERROR", (Object[])new String[]{handlerClassName}), (Throwable)e);
        }
    }

    private void uncheckInfiniteRecursion(String s) {
        this.infiniteRecursionChecker.remove(s);
    }

    private class BuiltinHandlerTypeEntry {
        private final boolean hasName;
        private final Class handlerClass;

        public BuiltinHandlerTypeEntry(Class theClass, boolean isNamed) {
            this.hasName = isNamed;
            this.handlerClass = theClass;
        }

        public Handler createHandler() throws LocalizableException {
            try {
                return (Handler)this.handlerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ClassLoadErrorException(this.handlerClass.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ClassLoadErrorException(this.handlerClass.getName(), e);
            }
        }

        public boolean hasName() {
            return this.hasName;
        }
    }
}

