/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;

public class HandlerLogger {
    static final String LOG_CONTEXT_KEY = "LogContext";
    private final TraceLoggerImpl traceLogger;
    private String methodName;

    public HandlerLogger(LogTypedLogger theLogger) {
        this.traceLogger = new TraceLoggerImpl(theLogger);
        this.methodName = "unknown";
    }

    private LogData createLogData(MessageContext theContext) {
        LogData logData = this.traceLogger.getLogData();
        MessageContextImpl mc = (MessageContextImpl)theContext;
        mc.populateLogData(logData);
        return logData;
    }

    public boolean isEnabled() {
        return this.traceLogger.isEnabled(Logger.LEVEL3);
    }

    public void logEnter(String theMethodName, MessageContext theContext) {
        if (this.isEnabled()) {
            RequestContext context = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
            LogContext logContext = context.getLogContext();
            theContext.putLocal(LOG_CONTEXT_KEY, (Object)logContext);
            this.methodName = theMethodName;
            this.traceLogger.enter(logContext, ComponentImpl.getInstance(), Logger.LEVEL3, theMethodName);
            if (this.traceLogger.isEnabled(Logger.LEVEL5)) {
                LogData logData = this.createLogData(theContext);
                this.traceLogger.parameterReceive(logContext, ComponentImpl.getInstance(), Logger.LEVEL5, logData);
            }
        }
    }

    public void logException(Exception theException, MessageContext theContext) {
        if (this.traceLogger.isEnabled(Logger.LEVEL4)) {
            LogContext logContext = (LogContext)theContext.getLocal(LOG_CONTEXT_KEY);
            LogData logData = this.traceLogger.getLogData();
            logData.setException(theException);
            this.traceLogger.resultSend(logContext, ComponentImpl.getInstance(), Logger.LEVEL4, logData);
        }
    }

    public void logExit(MessageContext theContext) {
        if (this.isEnabled()) {
            LogContext logContext = (LogContext)theContext.getLocal(LOG_CONTEXT_KEY);
            if (this.traceLogger.isEnabled(Logger.LEVEL5)) {
                LogData logData = this.createLogData(theContext);
                this.traceLogger.parameterSend(logContext, ComponentImpl.getInstance(), Logger.LEVEL5, logData);
            }
            this.traceLogger.exit(logContext, ComponentImpl.getInstance(), Logger.LEVEL3, this.methodName);
        }
    }

    public void logReturnValue(String theReturnValue, MessageContext theContext) {
        if (this.traceLogger.isEnabled(Logger.LEVEL4)) {
            LogContext logContext = (LogContext)theContext.getLocal(LOG_CONTEXT_KEY);
            LogData logData = this.traceLogger.getLogData();
            logData.setReturnValue(theReturnValue);
            this.traceLogger.resultSend(logContext, ComponentImpl.getInstance(), Logger.LEVEL4, logData);
        }
    }
}

