/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidCfgAttributeValueException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerLogger;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import org.dom4j.Element;

public abstract class HandlerWrapper
implements Handler {
    private String name;
    private Handler handler;

    protected HandlerWrapper() {
        this.name = null;
        this.handler = null;
    }

    protected HandlerWrapper(String theName, Handler theHandler) {
        this.name = theName;
        this.handler = theHandler;
    }

    public void close(MessageContext theContext) {
        MessageContextImpl mc = (MessageContextImpl)theContext;
        mc.pushContextKey(this.name);
        HandlerLogger handlerLogger = this.getLogger(mc);
        if (handlerLogger != null) {
            handlerLogger.logEnter("close", theContext);
        }
        try {
            this.handler.close(theContext);
        }
        catch (RuntimeException rte) {
            if (handlerLogger != null) {
                handlerLogger.logException(rte, theContext);
            }
            throw rte;
        }
        finally {
            if (handlerLogger != null) {
                handlerLogger.logExit(theContext);
            }
            mc.popContextKey();
        }
    }

    public void destroy() {
        this.handler = null;
    }

    private HandlerLogger getLogger(MessageContextImpl theContext) {
        String loggerName = "Trace.CAM.AAA.SRVC" + theContext.getContextKey();
        LogTypedLogger logger = LogTypedLogger.getInstance((String)loggerName, LogTraceIndication.class);
        return new HandlerLogger(logger);
    }

    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        boolean retval = true;
        MessageContextImpl mc = (MessageContextImpl)theContext;
        mc.pushContextKey(this.name);
        HandlerLogger handlerLogger = this.getLogger(mc);
        if (handlerLogger != null) {
            handlerLogger.logEnter("handleFault", theContext);
        }
        try {
            retval = this.handler.handleFault(theContext);
            if (handlerLogger != null) {
                handlerLogger.logReturnValue(Boolean.toString(retval), theContext);
            }
        }
        catch (SoapFaultException sfe) {
            if (handlerLogger != null) {
                handlerLogger.logException((Exception)((Object)sfe), theContext);
            }
            throw sfe;
        }
        catch (RuntimeException rte) {
            if (handlerLogger != null) {
                handlerLogger.logException(rte, theContext);
            }
            throw rte;
        }
        finally {
            if (handlerLogger != null) {
                handlerLogger.logExit(theContext);
            }
            mc.popContextKey();
        }
        return retval;
    }

    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean retval = true;
        MessageContextImpl mc = (MessageContextImpl)theContext;
        mc.pushContextKey(this.name);
        HandlerLogger handlerLogger = this.getLogger(mc);
        if (handlerLogger != null) {
            handlerLogger.logEnter("handleMessage", theContext);
        }
        try {
            retval = this.handler.handleMessage(theContext);
            if (handlerLogger != null) {
                handlerLogger.logReturnValue(Boolean.toString(retval), theContext);
            }
        }
        catch (SoapFaultException sfe) {
            if (handlerLogger != null) {
                handlerLogger.logException((Exception)((Object)sfe), theContext);
            }
            throw sfe;
        }
        catch (RuntimeException rte) {
            if (handlerLogger != null) {
                handlerLogger.logException(rte, theContext);
            }
            throw rte;
        }
        finally {
            if (handlerLogger != null) {
                handlerLogger.logExit(theContext);
            }
            mc.popContextKey();
        }
        return retval;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.handler.init(theConfig);
    }

    protected void setHandler(Handler theHandler) {
        this.handler = theHandler;
    }

    protected void setName(Element theConfigElement) throws InvalidCfgAttributeValueException {
        this.name = theConfigElement.attributeValue("id");
        if (this.name == null) {
            throw new InvalidCfgAttributeValueException(HandlerWrapper.class.getName(), this.name, "id");
        }
    }
}

