/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.admin.handler.QueryCM;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResponse;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.exception.InvalidNamespaceSelectionException;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.handler.DispatchToNamespaceUtility;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequest;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.exception.VisaLostException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class InvokeNamespaceHandler
extends DefaultHandler {
    static final String CLEANUP_VISA_ON_EXCEPTION = "cleanupVisaOnException";
    private static final String NOT_IMPLEMENTED = "Not Implemented";
    private static final int AUTH_REDIRECTION_MAX = 10;
    private static final String COGNOS_NAMESPACE = "";
    private static final String REDIRECTION_COUNT = "com.ibm.cognos.camaaa.internal.common.handler.InvokeNamespaceHandler.RedirectionCount";
    private final Handler queryCM;
    private NamespaceManager namespaceManager;

    public InvokeNamespaceHandler() {
        this(new QueryCM());
    }

    InvokeNamespaceHandler(Handler theCmHandler) {
        this.queryCM = theCmHandler;
    }

    @Override
    public void destroy() {
        this.queryCM.destroy();
    }

    private void dispatchRequestToNamespace(MessageContext theContext, String namespaceId, int requestType) throws SoapFaultException {
        try {
            Handler handler = this.getRequestHandler(namespaceId, requestType);
            HandlerBinding binding = (HandlerBinding)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
            binding.handleRequestRequired(theContext, handler);
            this.processAuthenticationRedirection(theContext);
        }
        catch (VisaLostException e) {
            Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            if (passport != null) {
                PassportManager.getInstance().destroyPassport(passport.getID());
            }
            throw e;
        }
    }

    private int getRedirectionCount(MessageContext mc) {
        Integer count = (Integer)mc.getLocal(REDIRECTION_COUNT);
        if (count != null) {
            return count;
        }
        return 0;
    }

    private Handler getRequestHandler(String namespace, int requestType) throws SoapFaultException {
        if (namespace.length() == 0) {
            return this.queryCM;
        }
        HandlerBinding nsDispatcher = this.namespaceManager.getNamespaceBinding(namespace);
        if (nsDispatcher == null) {
            throw new InvalidNamespaceSelectionException(InvokeNamespaceHandler.class.getName());
        }
        return nsDispatcher.getHandler(requestType);
    }

    @Override
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        Boolean value = (Boolean)theContext.getLocal(CLEANUP_VISA_ON_EXCEPTION);
        Visa visa = (Visa)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa");
        if (value != null && value.booleanValue() && visa != null) {
            String namespaceId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
            MessageContext newContext = theContext.createMessageContextForNewRequest(DispatchToNamespaceUtility.LOGOFF_REQUEST);
            newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)namespaceId);
            newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa", (Object)visa);
            this.dispatchRequestToNamespace(newContext, namespaceId, 4);
        }
        return true;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        String namespaceId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        SoapEnvelope soapEnvelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapBodyEntry reqBodyEntry = soapEnvelope.getBody().getBodyEntry();
        int requestType = reqBodyEntry.getType();
        boolean isVisaPopulated = true;
        if (namespaceId.length() == 0 && requestType != 1) {
            return true;
        }
        switch (requestType) {
            case 22: {
                break;
            }
            case 2: {
                this.prepareLogonRequest(theContext, namespaceId, reqBodyEntry);
                theContext.putLocal(CLEANUP_VISA_ON_EXCEPTION, (Object)Boolean.TRUE);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                isVisaPopulated = this.populateVisa(theContext, namespaceId);
                break;
            }
            default: {
                throw new RuntimeException(NOT_IMPLEMENTED);
            }
        }
        if (isVisaPopulated) {
            this.dispatchRequestToNamespace(theContext, namespaceId, requestType);
            this.populateCmQueryResult(namespaceId, requestType, theContext);
        }
        return true;
    }

    private void incRedirectionCount(MessageContext mc) {
        Integer count = (Integer)mc.getLocal(REDIRECTION_COUNT);
        if (count != null) {
            mc.putLocal(REDIRECTION_COUNT, (Object)new Integer(count + 1));
        } else {
            mc.putLocal(REDIRECTION_COUNT, (Object)new Integer(0));
        }
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        super.init(theConfig);
        this.queryCM.init(theConfig);
        this.namespaceManager = (NamespaceManager)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.NamespaceManager");
    }

    private void populateCmQueryResult(String namespace, int requestType, MessageContext theContext) throws SoapFaultException {
        if (namespace.length() == 0 && requestType == 1) {
            SoapEnvelope response = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
            QueryResponse userInfoResponse = (QueryResponse)response.getBody().getBodyEntry();
            QueryResult[] results = userInfoResponse.getResult();
            if (results.length != 1) {
                throw new RuntimeException("Expected a single query result!");
            }
            QueryResult queryResult = (QueryResult)theContext.get((Object)QueryResult.class.getName());
            BaseClass[] objects = results[0].getAll();
            for (int i = 0; i < objects.length; ++i) {
                queryResult.add(objects[i]);
            }
        }
    }

    boolean populateVisa(MessageContext theContext, String namespace) throws SoapFaultException {
        if (!namespace.equals(COGNOS_NAMESPACE) && !theContext.containsKey((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa")) {
            Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            Visa visa = passport.get(namespace);
            if (visa != null) {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa", (Object)visa);
            } else {
                return false;
            }
        }
        return true;
    }

    void prepareLogonRequest(MessageContext theContext, String namespace, SoapBodyEntry reqBodyEntry) throws SoapFaultException {
        LogonRequest logonRequest;
        Credential credential;
        if (theContext.containsKey((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa")) {
            theContext.remove((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa");
        }
        if ((credential = (logonRequest = (LogonRequest)reqBodyEntry).getCredential(namespace)) != null) {
            theContext.put((Object)"requestCredentials", (Object)credential);
        }
        theContext.put((Object)"requestType", (Object)"provider_logon");
    }

    private void processAuthenticationRedirection(MessageContext theContext) throws SoapFaultException {
        String namespaceId = (String)theContext.remove((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.redirectionNamespaceId");
        if (namespaceId != null) {
            if (this.getRedirectionCount(theContext) > 10) {
                this.resetRedirectionCount(theContext);
                throw new UnrecoverableException(InvokeNamespaceHandler.class.getName(), (LocalizableMessage)new Message("AAA_CAP_AUTHENTICATION_REDIRECTION_FAILED"), (LocalizableMessage)new Message("AAA_AUT_AUTHENTICATION_REDIRECTION_FAILED"));
            }
            this.incRedirectionCount(theContext);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)namespaceId);
            this.dispatchRequestToNamespace(theContext, namespaceId, 2);
            this.resetRedirectionCount(theContext);
        }
    }

    private void resetRedirectionCount(MessageContext mc) {
        mc.removeLocal(REDIRECTION_COUNT);
    }
}

