/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.handler.UniqueHashCode;

public class IsolatedHandler
extends UniqueHashCode
implements Handler {
    private final ClassLoader classLoader;
    private final Handler handler;

    public IsolatedHandler(Handler theHandler, ClassLoader theClassLoader) {
        this.handler = theHandler;
        this.classLoader = theClassLoader;
    }

    public void close(MessageContext theContext) {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.handler.close(theContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    public void destroy() {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.handler.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            boolean bl = this.handler.handleFault(theContext);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            boolean bl = this.handler.handleMessage(theContext);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.handler.init(theConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }
}

