/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.util.XmlUtils;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.exception.HandlerChainConfigException;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerConfigTester;
import com.ibm.cognos.camaaa.internal.common.handler.LogonTesterRequestProvider;
import com.ibm.cognos.camaaa.internal.common.handler.LogonTesterResponseProcessor;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.CAMCommonServiceHandler;
import com.ibm.cognos.camaaa.internal.common.service.CAMFlipperConfigurationNsTest;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class LogonTester {
    private static final String SERVICE_NAME = "CnfgLogonTest";
    private static final Logger LOGGER = Hierarchy.getDefaultHierarchy().getLoggerFor(HandlerConfigTester.class.getName());
    private final CAMCommonServiceHandler commonServiceHandler = new CAMCommonServiceHandler(LOGGER);

    public LogonTester(ICCLConfiguration cclConfiguration) throws HandlerChainConfigException {
        CAMFlipperConfigurationNsTest camFlipperConfig = new CAMFlipperConfigurationNsTest(cclConfiguration);
        this.commonServiceHandler.configure(camFlipperConfig, false, SERVICE_NAME, null);
        if (this.commonServiceHandler.getConfigMgr() == null) {
            throw new HandlerChainConfigException(SERVICE_NAME, null);
        }
    }

    public String attemptLogon(String credentials, HandlerConfigTester.Feedback feedback) throws SoapFaultException {
        String request = LogonTesterRequestProvider.getLogonRequest(credentials);
        SoapEnvelopeResponse soapResponse = this.executeRequest(request);
        if (this.isFault(soapResponse)) {
            this.displayFault(soapResponse, feedback);
        }
        String passport = LogonTesterResponseProcessor.extractPassport(soapResponse, feedback);
        return passport;
    }

    public boolean getAccountPropertiesAndMembership(String passport, HandlerConfigTester.Feedback feedback) throws SoapFaultException {
        String request = LogonTesterRequestProvider.getQueryAcctPropertiesRequest(passport);
        MessageContextImpl messageContext = this.createMessageContext(request);
        SoapEnvelopeResponse soapResponse = this.executeRequest(messageContext);
        boolean result = true;
        if (this.isFault(soapResponse)) {
            this.displayFault(soapResponse, feedback);
            result = false;
        } else {
            RequestContext requestContext = (RequestContext)messageContext.get("com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
            List<String> membership = LogonTesterResponseProcessor.extractUserPropertiesAndMembership(soapResponse, requestContext, feedback);
            if (membership.size() > 0) {
                ListIterator<String> iterator = membership.listIterator();
                while (iterator.hasNext()) {
                    String value = iterator.next();
                    iterator.set(XmlUtils.xmlEncodeElement((String)value));
                }
                result = this.getMembershipNames(passport, membership, feedback);
            }
        }
        return result;
    }

    public boolean getMembershipNames(String passport, List<String> membership, HandlerConfigTester.Feedback feedback) throws SoapFaultException {
        String request = LogonTesterRequestProvider.getQueryPropertyNamesRequest(membership, passport);
        MessageContextImpl messageContext = this.createMessageContext(request);
        SoapEnvelopeResponse soapResponse = this.executeRequest(messageContext);
        if (this.isFault(soapResponse)) {
            this.displayFault(soapResponse, feedback);
            return false;
        }
        RequestContext requestContext = (RequestContext)messageContext.get("com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        LogonTesterResponseProcessor.extractMemberOfNames(soapResponse, requestContext, feedback);
        return true;
    }

    public boolean getTenancy(String passport, HandlerConfigTester.Feedback feedback) throws SoapFaultException {
        String request = LogonTesterRequestProvider.getIdentityRequest(passport);
        SoapEnvelopeResponse soapResponse = this.executeRequest(request);
        if (this.isFault(soapResponse)) {
            this.displayFault(soapResponse, feedback);
            return false;
        }
        LogonTesterResponseProcessor.extractTenancy(soapResponse, feedback);
        return true;
    }

    public void dispose() {
        this.commonServiceHandler.dispose(SERVICE_NAME);
    }

    private boolean isFault(SoapEnvelopeResponse soapResponse) {
        SoapFault fault = soapResponse.getFaultEntry();
        return fault != null;
    }

    private void displayFault(SoapEnvelopeResponse soapResponse, HandlerConfigTester.Feedback feedback) {
        LocalizableMessage[] messages;
        SoapFault fault = soapResponse.getFaultEntry();
        for (LocalizableMessage message : messages = fault.getFaultDetail()) {
            feedback.showError(message.getLocalizedMessage(Locale.getDefault()));
        }
    }

    private SoapEnvelopeResponse executeRequest(String request) throws InvalidRequestException {
        MessageContextImpl messageContext = this.createMessageContext(request);
        SoapEnvelopeResponse soapResponse = this.executeRequest(messageContext);
        return soapResponse;
    }

    private SoapEnvelopeResponse executeRequest(MessageContextImpl messageContext) throws InvalidRequestException {
        this.commonServiceHandler.invokeImpl(messageContext);
        SoapEnvelopeResponse soapResponse = (SoapEnvelopeResponse)messageContext.get("com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        return soapResponse;
    }

    private MessageContextImpl createMessageContext(String request) throws InvalidRequestException {
        Element soapEnvelope = LogonTesterRequestProvider.getRequestSoapEnvelope(request);
        MessageContextImpl messageContext = null;
        try {
            messageContext = LogonTesterRequestProvider.buildMessageContext(soapEnvelope);
        }
        catch (SoapFaultException e) {
            throw new InvalidRequestException(this.getClass().getName(), e.getLocalizableMessage(), (Exception)((Object)e));
        }
        return messageContext;
    }
}

