/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.admin.cognosns.CognosOMBridgeSoapAction;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.CAMStandAloneServlet;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public final class LogonTesterRequestProvider {
    private static final String HEADER_TAG = "#HEADER#";
    private static final String PASSPORT_TAG = "#PASSPORT#";
    private static final String BODY_TAG = "#BODY#";
    private static final String QUERY_ITEMS_TAG = "#QUERY_ITEMS#";
    private static final String REQUEST_ENVELOPE = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><SOAP-ENV:Header><bus:biBusHeader xsi:type=\"bus:biBusHeader\">#HEADER#</bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body>#BODY#</SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final String REQUEST_HEADER = "<CAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"bus:CAM\"><CAMPassport xsi:type=\"bus:CAMPassport\"><id xsi:type=\"xsd:string\" xml:space=\"preserve\">#PASSPORT#</id></CAMPassport></CAM>";
    private static final String LOGON_REQUEST_BODY = "<cam:logon xmlns:cam=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xtsext=\"xalan://com.cognos.xts.ext.XTSExt\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><credentials xsi:type=\"cam:xmlEncodedXML\">#CREDENTIAL#</credentials><logonOptions xsi:type=\"SOAP-ENV:Array\" SOAP-ENC:arrayType=\"cam:logonOptionEnum[]\"><item xsi:type=\"cam:logonOptionEnum\">IgnoreAnonymous</item><item xsi:type=\"cam:logonOptionEnum\">PromptForRoles</item></logonOptions></cam:logon>";
    private static final String QUERY_REQUEST_BODY = "<cam:query xmlns:cam=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cam:queryRequest[]\">#QUERY_ITEMS#</requests></cam:query>";
    private static final String QUERY_ITEM = "<item xsi:type=\"cam:queryRequest\"><search xsi:type=\"xsd:string\">#SEARCH_PATH#</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cam:propEnum[]\">#PROPERTIES#</properties></item>";
    private static final String REQUEST_BODY_GETIDENTITY = "<cam:getIdentity xmlns:cam=\"http://developer.cognos.com/schemas/bibus/3/\"></cam:getIdentity>";
    private static final String ITEM_ELEMENT = "<item xsi:type=\"cam:propEnum\">#PROPERTY#</item>";
    private static final String[] USER_PROPERTIES = new String[]{"defaultName", "userName", "givenName", "surname", "email", "businessPhone", "mobilePhone", "homePhone", "faxPhone", "pagerPhone", "postalAddress", "memberOf"};
    private static final String ACCOUNT_SEARCH_PATH = "~";
    private static final String[] MEMBERSHIP_PROPERTIES = new String[]{"defaultName"};

    private LogonTesterRequestProvider() {
    }

    public static String getLogonRequest(String credentials) {
        String request = REQUEST_ENVELOPE.replaceFirst(HEADER_TAG, "");
        String escapedCredentials = Matcher.quoteReplacement(credentials);
        String logonRequestBody = LOGON_REQUEST_BODY.replaceFirst("#CREDENTIAL#", escapedCredentials);
        String escapedlogonRequestBody = Matcher.quoteReplacement(logonRequestBody);
        request = request.replaceFirst(BODY_TAG, escapedlogonRequestBody);
        return request;
    }

    public static String getQueryAcctPropertiesRequest(String passport) {
        String header = REQUEST_HEADER.replaceFirst(PASSPORT_TAG, passport);
        String request = REQUEST_ENVELOPE.replaceFirst(HEADER_TAG, header);
        String queryItems = LogonTesterRequestProvider.getQueryItems(ACCOUNT_SEARCH_PATH, USER_PROPERTIES);
        request = request.replaceFirst(BODY_TAG, QUERY_REQUEST_BODY.replaceFirst(QUERY_ITEMS_TAG, queryItems));
        return request;
    }

    public static String getQueryPropertyNamesRequest(List<String> memberOf, String passport) {
        String header = REQUEST_HEADER.replaceFirst(PASSPORT_TAG, passport);
        String request = REQUEST_ENVELOPE.replaceFirst(HEADER_TAG, header);
        StringBuilder items = new StringBuilder();
        for (String searchPath : memberOf) {
            String queryItems = LogonTesterRequestProvider.getQueryItems(searchPath, MEMBERSHIP_PROPERTIES);
            items.append(queryItems);
        }
        request = request.replaceFirst(BODY_TAG, QUERY_REQUEST_BODY.replaceFirst(QUERY_ITEMS_TAG, items.toString()));
        return request;
    }

    public static String getIdentityRequest(String passport) {
        String header = REQUEST_HEADER.replaceFirst(PASSPORT_TAG, passport);
        String request = REQUEST_ENVELOPE.replaceFirst(HEADER_TAG, header);
        request = request.replaceFirst(BODY_TAG, REQUEST_BODY_GETIDENTITY);
        return request;
    }

    private static String getQueryItems(String searchPath, String[] properties) {
        StringBuilder items = new StringBuilder();
        String queryItem = QUERY_ITEM.replaceFirst("#SEARCH_PATH#", searchPath);
        for (String property : properties) {
            String item = ITEM_ELEMENT.replaceFirst("#PROPERTY#", property);
            items.append(item);
        }
        queryItem = queryItem.replaceFirst("#PROPERTIES#", items.toString());
        return queryItem;
    }

    public static Element getRequestSoapEnvelope(String request) throws InvalidRequestException {
        Document doc = null;
        try {
            ByteArrayInputStream requestStream = new ByteArrayInputStream(request.getBytes("UTF-8"));
            doc = DocumentHelper.parse((InputStream)requestStream);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException(CAMStandAloneServlet.class.toString(), (LocalizableMessage)new Message("AAA_REQ_E_ERROR_PARSING_REQUEST"), e);
        }
        catch (DocumentException e) {
            throw new InvalidRequestException(CAMStandAloneServlet.class.toString(), (LocalizableMessage)new Message("AAA_REQ_E_ERROR_PARSING_REQUEST"), (Exception)((Object)e));
        }
        Element soapEnvelope = doc.getRootElement();
        return soapEnvelope;
    }

    public static MessageContextImpl buildMessageContext(Element soapEnvelope) throws SoapFaultException {
        MessageContextImpl messageContext = new MessageContextImpl(soapEnvelope);
        messageContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapAction", CognosOMBridgeSoapAction.getLatestSoapAction());
        messageContext.put("com.ibm.cognos.camaaa.internal.common.service.authRequest", Boolean.TRUE);
        messageContext.put("com.ibm.cognos.camaaa.internal.common.service.legacyRequest", Boolean.FALSE);
        messageContext.put("com.ibm.cognos.camaaa.internal.common.service.requestElement", soapEnvelope);
        return messageContext;
    }
}

