/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResponse;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.auth.soap.GetIdentityResponse;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerConfigTester;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class LogonTesterResponseProcessor {
    private static final String CR = "\n";
    private static final String TAB = "      ";
    private static final String EMPTY_STR = "";

    private LogonTesterResponseProcessor() {
    }

    public static void extractTenancy(SoapEnvelopeResponse soapResponse, HandlerConfigTester.Feedback feedback) throws SoapFaultException {
        SoapBody body = soapResponse.getBody();
        GetIdentityResponse response = (GetIdentityResponse)body.getBodyEntry();
        TenancyInfo tenancy = response.getIdentityTenancy();
        String tenantID = tenancy.getTenancy(TenancyInfo.TenancyType.TENANTID);
        String[] tenantBoundingSet = tenancy.getTenancies(TenancyInfo.TenancyType.READ_TENANTID);
        Message tenancyLabel = new Message("AAA_CAP_TENANCY_LABEL");
        feedback.showInformation(CR + tenancyLabel.getLocalizedMessage(Locale.getDefault()));
        if (tenantID != null) {
            feedback.showInformation(TAB + tenantID);
        } else {
            Message noTenantLabel = new Message("AAA_CAP_TENANCY_NONE_LABEL");
            feedback.showInformation(TAB + noTenantLabel.getLocalizedMessage(Locale.getDefault()));
        }
        Message tenantBoundingSetLabel = new Message("AAA_CAP_TENANTBOUNDINGSET_LABEL");
        feedback.showInformation(CR + tenantBoundingSetLabel.getLocalizedMessage(Locale.getDefault()));
        if (tenantBoundingSet != null && !LogonTesterResponseProcessor.isEmptyBoundingSet(tenantBoundingSet)) {
            for (String tenant : tenantBoundingSet) {
                if (tenant.isEmpty()) continue;
                feedback.showInformation(TAB + tenant);
            }
        } else {
            Message noBoundingSetLabel = new Message("AAA_CAP_TENANTBOUNDINGSET_NONE_LABEL");
            feedback.showInformation(TAB + noBoundingSetLabel.getLocalizedMessage(Locale.getDefault()));
        }
    }

    private static boolean isEmptyBoundingSet(String[] tenantBoundingSet) {
        boolean hasJustPublic = tenantBoundingSet.length == 1 && tenantBoundingSet[0].isEmpty();
        return tenantBoundingSet.length == 0 || hasJustPublic;
    }

    public static void extractMemberOfNames(SoapEnvelopeResponse soapResponse, RequestContext requestContext, HandlerConfigTester.Feedback feedback) {
        SoapBody body = soapResponse.getBody();
        QueryResponse queryResponse = (QueryResponse)body.getBodyEntry();
        QueryResult[] queryResults = queryResponse.getResult();
        Message mebershipLabel = new Message("AAA_CAP_MEMBERSHIP_LABEL");
        feedback.showInformation(mebershipLabel.getLocalizedMessage(Locale.getDefault()));
        for (QueryResult queryResult : queryResults) {
            BaseClass group = queryResult.getAll()[0];
            String value = group.getDefaultName(requestContext);
            feedback.showInformation(TAB + value);
        }
    }

    public static List<String> extractUserPropertiesAndMembership(SoapEnvelopeResponse soapResponse, RequestContext requestContext, HandlerConfigTester.Feedback feedback) {
        SoapBody body = soapResponse.getBody();
        QueryResponse queryResponse = (QueryResponse)body.getBodyEntry();
        QueryResult queryResult = queryResponse.getResult()[0];
        Account account = (Account)queryResult.getAll()[0];
        Message userPropertiesLabel = new Message("AAA_CAP_USERPROPERTIES_LABEL");
        StringBuilder properties = new StringBuilder(userPropertiesLabel.getLocalizedMessage(Locale.getDefault()));
        properties.append(CR);
        String defaultName = account.getDefaultName(requestContext);
        properties.append(LogonTesterResponseProcessor.buildPropertyString("defaultName", defaultName));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("userName", account.getUserName()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("givenName", account.getGivenName()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("surname", account.getSurname()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("email", account.getEmail()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("businessPhone", account.getBusinessPhone()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("mobilePhone", account.getMobilePhone()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("homePhone", account.getHomePhone()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("faxPhone", account.getFaxPhone()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("pagerPhone", account.getPagerPhone()));
        properties.append(LogonTesterResponseProcessor.buildPropertyString("postalAddress", account.getPostalAddress()));
        ArrayList<String> searchPaths = new ArrayList<String>();
        BaseClass[] groups = account.getMemberOf();
        if (groups != null) {
            for (BaseClass group : groups) {
                SearchPath path = group.getSearchPath();
                searchPaths.add(path.getValue());
            }
        }
        feedback.showInformation(properties.toString());
        return searchPaths;
    }

    private static String buildPropertyString(String porpertyLabel, String propertyValue) {
        String resultValue = null;
        resultValue = propertyValue != null ? propertyValue : EMPTY_STR;
        return TAB + porpertyLabel + ": " + resultValue + CR;
    }

    public static String extractPassport(SoapEnvelopeResponse soapResponse, HandlerConfigTester.Feedback feedback) {
        SoapHeader header = soapResponse.getHeader();
        String passportID = header.getBiBusHeader().getCAMPassportID();
        return passportID;
    }
}

