/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public final class QueryTenantMembershipBuilder {
    private static final XPath TENANTIDS_XPATH = DocumentHelper.createXPath((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/cm1:queryTenantMembershipResponse/result/item");

    private QueryTenantMembershipBuilder() {
    }

    public static Element createRequestBodyForQueryTenantMembership(MessageContext theContext) {
        Element soapBodyElement = CMAccessor.createSoapBodyElement();
        Element queryTenantMembership = soapBodyElement.addElement(new QName("queryTenantMembership", XMLConstants.CM1_NS));
        String tenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID");
        String[] boundingSet = (String[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds");
        int totalLength = 0;
        if (tenantID != null) {
            ++totalLength;
        }
        if (boundingSet != null) {
            totalLength += boundingSet.length;
        }
        Element tenantIDsEl = queryTenantMembership.addElement("tenantIDs");
        tenantIDsEl.addAttribute(XMLConstants.XSI_TYPE, DocumentHelper.createQualifiedElementName((String)"SOAP-ENC", (String)"Array"));
        tenantIDsEl.addAttribute(new QName("arrayType", new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/")), "xsd:string[" + totalLength + "]");
        if (tenantID != null) {
            QueryTenantMembershipBuilder.addItemWithText(tenantIDsEl, tenantID);
        }
        if (boundingSet != null) {
            for (String tenantMember : boundingSet) {
                QueryTenantMembershipBuilder.addItemWithText(tenantIDsEl, tenantMember);
            }
        }
        return soapBodyElement;
    }

    public static Set<String> parseResponse(Document responseDoc) {
        List tenantIds = TENANTIDS_XPATH.selectNodes((Object)responseDoc);
        HashSet<String> result = new HashSet<String>(tenantIds.size());
        for (Node tenantId : tenantIds) {
            result.add(tenantId.getText());
        }
        return result;
    }

    private static void addItemWithText(Element addTo, String text) {
        Element item = addTo.addElement("item");
        item.addAttribute(XMLConstants.XSI_TYPE, "xsd:string");
        item.setText(text);
    }
}

