/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.handler;

import com.ibm.cognos.camaaa.internal.admin.cognosns.CognosOMBridgeSoapAction;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.BadXmlFileException;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBindingImpl;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerDispatcher;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactory;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class ServiceHandlerDispatcher {
    private static final String WILD_CARD_STRING = "*";
    private static final String OMBRIDGE_BRIDGE_HANDLER = "com.ibm.cognos.internal.ombridge.BridgeHandler";
    private static final String ACTOR = ServiceHandlerDispatcher.class.toString();
    private static final String SERVICE_ELEMENT = "service";
    private static final String SOAP_ACTION = "soapAction";
    private final Map<String, HandlerBindingImpl> handlerBindings = new HashMap<String, HandlerBindingImpl>();
    private final HandlerFactory handlerFactory;
    private String prodVersion;

    public ServiceHandlerDispatcher(HandlerFactory theFactory) {
        this.handlerFactory = theFactory;
    }

    public void destroy() {
        this.handlerBindings.clear();
        this.handlerFactory.destroy();
    }

    public HandlerBinding getInternalHandlerDispatcher() {
        return this.handlerBindings.get(null);
    }

    public void handleRequest(MessageContextImpl messageContext, int type) throws LocalizableException {
        String soapAction = (String)messageContext.get("com.ibm.cognos.camaaa.internal.common.handler.message.soapAction");
        HandlerBindingImpl handlerBinding = this.handlerBindings.get(soapAction);
        if (handlerBinding == null) {
            throw new InvalidRequestException(ACTOR, (LocalizableMessage)new Message("AAA_REQ_E_INVALID_SOAP_ACTION", new Object[]{soapAction}));
        }
        Handler theHandler = handlerBinding.getHandler(type);
        if (theHandler == null) {
            throw new InvalidRequestException(ACTOR, (LocalizableMessage)new Message("AAA_REQ_E_INVALID_REQUEST_TYPE", new Object[]{HandlerBindingImpl.getRequestName(type)}));
        }
        messageContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding", handlerBinding);
        handlerBinding.handleRequest(messageContext, theHandler);
    }

    public void init(String file, Configuration config) throws LocalizableException {
        Element configDoc = HandlerDispatcher.getHandlerConfiguration(file);
        if (configDoc.getName() != "handler-configuration") {
            throw new BadXmlFileException(file, null);
        }
        this.handlerFactory.init(config, configDoc.asXML());
        Iterator serviceIterator = configDoc.elementIterator(SERVICE_ELEMENT);
        while (serviceIterator.hasNext()) {
            Element serviceElement = (Element)serviceIterator.next();
            HandlerBindingImpl binding = new HandlerBindingImpl(this.handlerFactory);
            HandlerDispatcher.loadActions(config, serviceElement, this.handlerFactory, binding);
            Iterator soapActionIterator = serviceElement.elementIterator(SOAP_ACTION);
            while (soapActionIterator.hasNext()) {
                Element soapActionElement = (Element)soapActionIterator.next();
                String soapAction = soapActionElement.getText();
                if (soapAction.endsWith(WILD_CARD_STRING)) {
                    int lastIndex = soapAction.lastIndexOf(WILD_CARD_STRING);
                    if (lastIndex != -1) {
                        soapAction = soapAction.substring(0, lastIndex);
                    }
                    List<String> versions = CognosOMBridgeSoapAction.getSupportedVersions();
                    for (String version : versions) {
                        String computedSoapAction = soapAction + version + "/";
                        this.handlerBindings.put(computedSoapAction, binding);
                    }
                    continue;
                }
                this.handlerBindings.put(soapAction, binding);
            }
        }
        HandlerBindingImpl legacyBinding = this.handlerBindings.get("http://developer.cognos.com/schemas/bibus/3#CAM.legacy");
        if (legacyBinding != null) {
            this.handlerBindings.put(null, legacyBinding);
        }
    }
}

