/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.logging.AuditLogger;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.Locale;

public class AuditLoggerImpl
implements AuditLogger {
    private final LogTypedLogger logger;

    public AuditLoggerImpl(LogTypedLogger theTypedLogger) {
        this.logger = theTypedLogger;
    }

    private LogAuditAccessIndication getLogAuditAccessIndication(LogContext theLogContext, Component theComponent) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication(theComponent.getID(), theComponent.getBuildNumber());
        indication.setRequestID(theLogContext.getRequestContext());
        indication.setSessionID(theLogContext.getSessionContext());
        indication.setStepID(theLogContext.getStepContext());
        indication.setSubRequestID(theLogContext.getHopCount().toString());
        return indication;
    }

    private LogAuditIndication getLogAuditIndication(LogContext theLogContext, Component theComponent) {
        LogAuditIndication indication = new LogAuditIndication(theComponent.getID(), theComponent.getBuildNumber());
        indication.setRequestID(theLogContext.getRequestContext());
        indication.setSessionID(theLogContext.getSessionContext());
        indication.setStepID(theLogContext.getStepContext());
        indication.setSubRequestID(theLogContext.getHopCount().toString());
        return indication;
    }

    public LogData getLogData() {
        return new LogDataImpl();
    }

    public boolean isEnabled(int theLevel) {
        return this.logger.isEnabled(theLevel);
    }

    private void log(LogAuditIndication theIndication, int level, String theOperation, LogData theLogData) {
        theIndication.setLevel(level);
        theIndication.setOperation(theOperation);
        String logData = null;
        if (theLogData != null) {
            logData = theLogData.toString();
        }
        theIndication.setLogData(logData);
        this.logger.log((Object)theIndication);
    }

    public void logAuthenticationEvent(LogContext theLogContext, Component theComponent, int theLevel, LogData logData, String targetNS, String userId, String operation, String status, String errorMessage) {
        LogAuditAccessIndication indication = this.getLogAuditAccessIndication(theLogContext, theComponent);
        String objectPath = "/directory/" + targetNS + "/account/" + userId;
        indication.setOperation(operation);
        indication.setObjectType("Account");
        indication.setObjectPath(objectPath);
        indication.setStatus(status);
        if (errorMessage != null) {
            indication.setErrorMessage(errorMessage);
        }
        this.log((LogAuditIndication)indication, theLevel, operation, logData);
    }

    public void logEnter(LogContext theLogContext, Component theComponent, int theLevel, LogData theLogData) {
        LogAuditIndication indication = this.getLogAuditIndication(theLogContext, theComponent);
        this.log(indication, theLevel, "CallStart", theLogData);
    }

    public void logExit(LogContext theLogContext, Component theComponent, int theLevel, LogData theLogData) {
        LogAuditIndication indication = this.getLogAuditIndication(theLogContext, theComponent);
        this.log(indication, theLevel, "CallEnd", theLogData);
    }

    private void logLogonFailure(LogContext theLogContext, Component theComponent, LogData logData, String errorMessage) {
        LogAuditAccessIndication indication = this.getLogAuditAccessIndication(theLogContext, theComponent);
        indication.setStatus("Failure");
        indication.setErrorMessage(errorMessage);
        this.log((LogAuditIndication)indication, Logger.LEVEL2, "Logon", logData);
    }

    public void logLogonFailureDisabledTenant(LogContext theLogContext, Component theComponent, LogData logData, String tenantId, String userId, Locale productLocale) {
        Message message = new Message("AAA_AUT_MT_TENANT_DISABLED_AUDIT", new Object[]{userId, tenantId});
        String errorMessage = message.getLocalizedMessage(productLocale);
        this.logLogonFailure(theLogContext, theComponent, logData, errorMessage);
    }

    public void logLogonFailureNonExistentTenant(LogContext theLogContext, Component theComponent, LogData logData, String tenantId, String userId, Locale productLocale) {
        Message message = new Message("AAA_AUT_MT_TENANT_DOESNT_EXIST_AUDIT", new Object[]{userId, tenantId});
        String errorMessage = message.getLocalizedMessage(productLocale);
        this.logLogonFailure(theLogContext, theComponent, logData, errorMessage);
    }

    public void logRenewTCFailure(LogContext theLogContext, Component theComponent, LogData logData, String credentialPath, String errorMessage) {
        LogAuditAccessIndication indication = this.getLogAuditAccessIndication(theLogContext, theComponent);
        indication.setOperation("Trusted Credential");
        indication.setObjectType("Credential");
        indication.setObjectPath(credentialPath);
        indication.setStatus("Failure");
        if (errorMessage != null) {
            indication.setErrorMessage(errorMessage);
        }
        this.log((LogAuditIndication)indication, Logger.LEVEL3, "Trusted Credential", logData);
    }

    public void logSessionTerminate(LogContext theLogContext, Component theComponent, int theLevel, LogData logData, String sessionSearchPath, String status, String errorMessage) {
        LogAuditAccessIndication indication = this.getLogAuditAccessIndication(theLogContext, theComponent);
        indication.setOperation("Terminate");
        indication.setObjectType("Session");
        indication.setObjectPath(sessionSearchPath);
        indication.setStatus(status);
        if (errorMessage != null) {
            indication.setErrorMessage(errorMessage);
        }
        this.log((LogAuditIndication)indication, theLevel, "Terminate", logData);
    }
}

