/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.logging;

import com.ibm.cognos.camaaa.internal.common.logging.Component;
import java.util.StringTokenizer;

public class ComponentImpl
implements Component {
    private static final int DEFAULT_VERSION = 0;
    private static Component aaaComponent;
    private int productMajor;
    private int productMinor;
    private int buildMajor;
    private int buildMinor;
    private final String name;

    public ComponentImpl(String theComponentName, String theComponentVersion) {
        this.name = theComponentName;
        this.productMajor = 0;
        this.productMinor = 0;
        this.buildMajor = 0;
        this.buildMinor = 0;
        if (theComponentVersion != null) {
            int numberOfComponentsInVersion = 4;
            StringTokenizer t = new StringTokenizer(theComponentVersion, ".");
            if (t.countTokens() == 4) {
                this.productMajor = Integer.parseInt(t.nextToken());
                this.productMinor = Integer.parseInt(t.nextToken());
                this.buildMajor = Integer.parseInt(t.nextToken());
                this.buildMinor = Integer.parseInt(t.nextToken());
            }
        }
    }

    public static Component getInstance() {
        if (aaaComponent == null) {
            String version = null;
            Package camaaa = ComponentImpl.class.getPackage();
            if (camaaa != null) {
                version = camaaa.getImplementationVersion();
            }
            aaaComponent = new ComponentImpl("AAA", version);
        }
        return aaaComponent;
    }

    public int getBuildMajor() {
        return this.buildMajor;
    }

    public int getBuildMinor() {
        return this.buildMinor;
    }

    public int getBuildNumber() {
        return this.getBuildMajor();
    }

    public String getID() {
        return this.name;
    }

    public int getProductMajor() {
        return this.productMajor;
    }

    public int getProductMinor() {
        return this.productMinor;
    }
}

