/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.logging;

import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean;
import java.util.HashSet;
import java.util.Set;

public class DyeTraceManager
implements DyeTraceManagerMBean {
    private static DyeTraceManager instance;
    private final HashSet<String> camIds;
    private final NamespaceManager namespaceManager;

    public DyeTraceManager(NamespaceManager theNamespaceManager) {
        this.namespaceManager = theNamespaceManager;
        this.camIds = new HashSet();
    }

    public static synchronized DyeTraceManager getInstance(NamespaceManager theNamespaceManager) {
        if (instance == null) {
            instance = new DyeTraceManager(theNamespaceManager);
        }
        return instance;
    }

    @Override
    public void disableDyeTrace(String theUserCamId) {
        this.camIds.remove(theUserCamId);
    }

    @Override
    public void enableDyeTrace(String theUserCamId) {
        try {
            SearchPathImpl searchPath = new SearchPathImpl(theUserCamId);
            Namespace namespace = this.namespaceManager.getNamespace(searchPath.getNamespaceID());
            if (namespace != null) {
                this.camIds.add(theUserCamId);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public Set<String> getDyeTracedUsers() {
        return this.camIds;
    }

    @Override
    public void resetDyeTracedUsers() {
        this.camIds.clear();
    }
}

