/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.logging;

import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class LogDataImpl
implements LogData {
    private static final String UTF_8 = "UTF-8";
    private static final QName FUNCTION = new QName("function");
    private static final QName NAME = new QName("name");
    private static final QName PARAMETERS = new QName("parameters");
    private static final QName ITEM = new QName("item");
    private static final QName EXCEPTION = new QName("exception");
    private static final QName RETURN_VALUE = new QName("returnvalue");
    private static final String NULL_VALUE = "null";
    private Document document;
    private Element parameters;
    private Element returnValue;
    private Element exception;
    private Element function;

    public LogDataImpl() {
        this.init();
    }

    public static String toCompactNoDeclarationUtf8String(Element theElement) {
        String retval = null;
        if (theElement != null) {
            theElement.normalize();
            OutputFormat outformat = OutputFormat.createCompactFormat();
            outformat.setSuppressDeclaration(true);
            outformat.setEncoding(UTF_8);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                XMLWriter writer = new XMLWriter((OutputStream)out, outformat);
                writer.write(theElement);
                writer.flush();
                writer.close();
                retval = out.toString(UTF_8);
                out.close();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return retval;
    }

    public void addParameter(String theName, String theValue) {
        if (this.parameters == null) {
            this.parameters = this.function != null ? this.function.addElement(PARAMETERS) : this.document.addElement(PARAMETERS);
        }
        Element item = this.parameters.addElement(ITEM);
        item.addAttribute(NAME, theName);
        if (theValue == null) {
            item.addCDATA(NULL_VALUE);
        } else {
            item.addCDATA(theValue);
        }
    }

    public void init() {
        this.document = DocumentFactory.getInstance().createDocument();
        this.function = null;
        this.parameters = null;
        this.returnValue = null;
        this.exception = null;
    }

    public void init(String theFunctionName) {
        this.init();
        this.function = this.document.addElement(FUNCTION);
        if (theFunctionName == null) {
            this.function.addAttribute(NAME, NULL_VALUE);
        } else {
            this.function.addAttribute(NAME, theFunctionName);
        }
    }

    public void setException(Exception e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        e.printStackTrace(ps);
        ps.close();
        if (this.exception != null) {
            this.exception.getParent().remove(this.exception);
        }
        this.exception = this.function != null ? this.function.addElement(EXCEPTION) : this.document.addElement(EXCEPTION);
        this.exception.addCDATA(out.toString());
    }

    public void setReturnValue(String theValue) {
        if (this.returnValue != null) {
            this.returnValue.getParent().remove(this.returnValue);
        }
        this.returnValue = this.function != null ? this.function.addElement(RETURN_VALUE) : this.document.addElement(RETURN_VALUE);
        if (theValue == null) {
            this.returnValue.addCDATA(NULL_VALUE);
        } else {
            this.returnValue.addCDATA(theValue);
        }
    }

    public String toString() {
        return LogDataImpl.toCompactNoDeclarationUtf8String(this.document.getRootElement());
    }
}

