/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.logging;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.PerfLogger;

public class PerfLoggerImpl
implements PerfLogger {
    private final LogTypedLogger logger;

    public PerfLoggerImpl(LogTypedLogger theTypedLogger) {
        this.logger = theTypedLogger;
    }

    public LogData getLogData() {
        return new LogDataImpl();
    }

    private LogPerfIndication getLogPerfIndication(LogContext theLogContext, Component theComponent) {
        LogPerfIndication indication = new LogPerfIndication(theComponent.getID(), theComponent.getBuildNumber(), new CCLResourceCounterSet());
        if (indication != null) {
            indication.setRequestID(theLogContext.getRequestContext());
            indication.setSessionID(theLogContext.getSessionContext());
            indication.setStepID(theLogContext.getStepContext());
            indication.setSubRequestID(theLogContext.getHopCount().toString());
        }
        return indication;
    }

    public boolean isEnabled(int theLevel) {
        return this.logger.isEnabled(theLevel);
    }

    public Object logEnter(LogContext theLogContext, Component theComponent, int theLevel, String theClassID, String theMethodID, String theSequenceID, LogData theLogData) {
        LogPerfIndication indication = this.getLogPerfIndication(theLogContext, theComponent);
        if (indication != null) {
            indication.setLevel(theLevel);
            indication.setClassId(theClassID);
            indication.setMethodId(theMethodID);
            indication.setSequenceId(theSequenceID);
            indication.setStatus("ENTER");
            indication.setSessionID(theLogContext.getSessionContext());
            indication.setRequestID(theLogContext.getRequestContext());
            indication.setSubRequestID(theLogContext.getHopCount().toString());
            String logData = null;
            if (theLogData != null) {
                logData = theLogData.toString();
            }
            indication.setLogData(logData);
            this.logger.log((Object)indication);
            indication.getCCLRCS().enableResourceCounter();
        }
        return indication;
    }

    public void logExit(Object theLogIndication, LogData theLogData) {
        if (!(theLogIndication instanceof LogPerfIndication)) {
            return;
        }
        LogPerfIndication indication = (LogPerfIndication)theLogIndication;
        if (indication != null) {
            indication.getCCLRCS().disableResourceCounter();
            indication.setStatus("EXIT");
            String logData = null;
            if (theLogData != null) {
                logData = theLogData.toString();
            }
            indication.setLogData(logData);
            this.logger.log((Object)indication);
        }
    }
}

