/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.logging;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.RequestResponseLogger;

public class RequestResponseLoggerImpl
implements RequestResponseLogger {
    private static final String CAM_SERVICE = "CAMAAASRVC";
    private final LogTypedLogger logger;

    public RequestResponseLoggerImpl(LogTypedLogger theLogger) {
        this.logger = theLogger;
    }

    public LogData getLogData() {
        return new LogDataImpl();
    }

    public boolean isEnabled(int theLevel) {
        return this.logger.isEnabled(theLevel);
    }

    private LogTraceIndication getLogTraceIndication(LogContext theLogContext, Component theComponent, int theLevel) {
        LogTraceIndication indication = new LogTraceIndication(theComponent.getID(), theComponent.getBuildNumber());
        indication.setLevel(theLevel);
        indication.setObject(CAM_SERVICE);
        if (theLogContext != null) {
            indication.setRequestID(theLogContext.getRequestContext());
            indication.setSessionID(theLogContext.getSessionContext());
            indication.setStepID(theLogContext.getStepContext());
            indication.setSubRequestID(theLogContext.getHopCount().toString());
        }
        return indication;
    }

    public void logRequest(LogContext theLogContext, Component theComponent, int theLevel, String request) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent, theLevel);
        indication.setAction((byte)7);
        indication.setMessage(request);
        this.logger.log((Object)indication);
    }

    public void logResponse(LogContext theLogContext, Component theComponent, int theLevel, String response) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent, theLevel);
        indication.setAction((byte)8);
        indication.setMessage(response);
        this.logger.log((Object)indication);
    }
}

