/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.logging;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;

public class TraceLoggerImpl
implements TraceLogger {
    static final String RESULT = "RESULT";
    static final String PARAMETER = "PARAMETER";
    private final LogTypedLogger logger;

    public TraceLoggerImpl(LogTypedLogger theTypedLogger) {
        this.logger = theTypedLogger;
    }

    public void call(LogContext theLogContext, Component theComponent, int theLevel, String theModule) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            this.log(indication, theLevel, theModule, (byte)3, null);
        }
    }

    public void enter(LogContext theLogContext, Component theComponent, int theLevel, String theModule) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            this.log(indication, theLevel, theModule, (byte)5, null);
        }
    }

    public void exit(LogContext theLogContext, Component theComponent, int theLevel, String theModule) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            this.log(indication, theLevel, theModule, (byte)6, null);
        }
    }

    public LogData getLogData() {
        return new LogDataImpl();
    }

    private LogTraceIndication getLogTraceIndication(LogContext theLogContext, Component theComponent) {
        LogTraceIndication indication = new LogTraceIndication(theComponent.getID(), theComponent.getBuildNumber());
        if (indication != null) {
            indication.setRequestID(theLogContext.getRequestContext());
            indication.setSessionID(theLogContext.getSessionContext());
            indication.setStepID(theLogContext.getStepContext());
            indication.setSubRequestID(theLogContext.getHopCount().toString());
        }
        return indication;
    }

    public boolean isEnabled(int theLevel) {
        return this.logger.isEnabled(theLevel);
    }

    private void log(LogTraceIndication theIndication, int theLevel, String theObject, byte theAction, String theMessage) {
        theIndication.setLevel(theLevel);
        theIndication.setObject(theObject);
        theIndication.setAction(theAction);
        theIndication.setMessage(theMessage);
        this.logger.log((Object)theIndication);
    }

    public void parameterReceive(LogContext theLogContext, Component theComponent, int theLevel, LogData theLogData) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            String logData = null;
            if (theLogData != null) {
                logData = theLogData.toString();
            }
            this.log(indication, theLevel, PARAMETER, (byte)8, logData);
        }
    }

    public void parameterSend(LogContext theLogContext, Component theComponent, int theLevel, LogData theLogData) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            String logData = null;
            if (theLogData != null) {
                logData = theLogData.toString();
            }
            this.log(indication, theLevel, PARAMETER, (byte)7, logData);
        }
    }

    public void resultReceive(LogContext theLogContext, Component theComponent, int theLevel, LogData theLogData) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            String logData = null;
            if (theLogData != null) {
                logData = theLogData.toString();
            }
            this.log(indication, theLevel, RESULT, (byte)8, logData);
        }
    }

    public void resultSend(LogContext theLogContext, Component theComponent, int theLevel, LogData theLogData) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            String logData = null;
            if (theLogData != null) {
                logData = theLogData.toString();
            }
            this.log(indication, theLevel, RESULT, (byte)7, logData);
        }
    }

    public void returnFrom(LogContext theLogContext, Component theComponent, int theLevel, String theModule) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            this.log(indication, theLevel, theModule, (byte)4, null);
        }
    }

    public void trace(LogContext theLogContext, Component theComponent, int level, String theControlPoint) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            this.log(indication, level, theControlPoint, (byte)11, null);
        }
    }

    public void trace(LogContext theLogContext, Component theComponent, int theLevel, String theControlPoint, LogData theLogData) {
        LogTraceIndication indication = this.getLogTraceIndication(theLogContext, theComponent);
        if (indication != null) {
            String logData = null;
            if (theLogData != null) {
                logData = theLogData.toString();
            }
            this.log(indication, theLevel, RESULT, (byte)11, logData);
        }
    }
}

